/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.a2a.internal.server.agent;

import com.mulesoft.connectors.a2a.api.model.card.AgentCard;
import com.mulesoft.connectors.a2a.internal.protocol.A2AProtocolSerializer;
import com.mulesoft.connectors.a2a.internal.protocol.JsonRpcSerializer;
import com.mulesoft.connectors.a2a.internal.server.agent.RpcRequestContext;
import com.mulesoft.connectors.a2a.internal.server.agent.push.EffectivePushNotificationConfig;
import com.mulesoft.connectors.a2a.internal.server.agent.repository.TaskRepository;
import com.mulesoft.connectors.a2a.internal.server.agent.repository.TaskStoreService;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import org.mule.runtime.http.api.domain.request.HttpRequestContext;
import org.mule.runtime.http.api.server.async.HttpResponseReadyCallback;

public class RequestHandlerContext {
    private AgentCard agentCard;
    private HttpRequestContext requestContext;
    private HttpResponseReadyCallback responseCallback;
    private RpcRequestContext rpcRequestContext;
    private JsonRpcSerializer rpcSerializer;
    private TaskRepository taskRepository;
    private TaskStoreService taskStoreService;
    private A2AProtocolSerializer a2aSerializer;
    private Consumer<RpcRequestContext> messageHandler;
    private Function<RpcRequestContext, CompletableFuture<EffectivePushNotificationConfig>> setPushNotificationConfigHandler;

    public static Builder builder() {
        return new Builder();
    }

    private RequestHandlerContext() {
    }

    public AgentCard getAgentCard() {
        return this.agentCard;
    }

    public HttpRequestContext getHttpRequestContext() {
        return this.requestContext;
    }

    public HttpResponseReadyCallback getResponseCallback() {
        return this.responseCallback;
    }

    public TaskStoreService getTaskStoreService() {
        return this.taskStoreService;
    }

    public JsonRpcSerializer getRpcSerializer() {
        return this.rpcSerializer;
    }

    public TaskRepository getTaskRepository() {
        return this.taskRepository;
    }

    public A2AProtocolSerializer getA2aSerializer() {
        return this.a2aSerializer;
    }

    public RpcRequestContext getRpcRequestContext() {
        return this.rpcRequestContext;
    }

    public Consumer<RpcRequestContext> getMessageHandler() {
        return this.messageHandler;
    }

    public Function<RpcRequestContext, CompletableFuture<EffectivePushNotificationConfig>> getSetPushNotificationConfigHandler() {
        return this.setPushNotificationConfigHandler;
    }

    public static class Builder {
        private RequestHandlerContext product = new RequestHandlerContext();

        private Builder() {
        }

        public Builder agentCard(AgentCard agentCard) {
            this.product.agentCard = agentCard;
            return this;
        }

        public Builder requestContext(HttpRequestContext requestContext) {
            this.product.requestContext = requestContext;
            return this;
        }

        public Builder taskStoreService(TaskStoreService taskStoreService) {
            this.product.taskStoreService = taskStoreService;
            return this;
        }

        public Builder responseCallback(HttpResponseReadyCallback responseCallback) {
            this.product.responseCallback = responseCallback;
            return this;
        }

        public Builder rpcRequestContext(RpcRequestContext rpcRequestContext) {
            this.product.rpcRequestContext = rpcRequestContext;
            return this;
        }

        public Builder serializer(JsonRpcSerializer serializer) {
            this.product.rpcSerializer = serializer;
            return this;
        }

        public Builder taskRepository(TaskRepository taskRepository) {
            this.product.taskRepository = taskRepository;
            return this;
        }

        public Builder messageSerializer(A2AProtocolSerializer messageSerializer) {
            this.product.a2aSerializer = messageSerializer;
            return this;
        }

        public Builder messageHandler(Consumer<RpcRequestContext> onMessage) {
            this.product.messageHandler = onMessage;
            return this;
        }

        public Builder onSetPushNotificationConfigHandler(Function<RpcRequestContext, CompletableFuture<EffectivePushNotificationConfig>> handler) {
            this.product.setPushNotificationConfigHandler = handler;
            return this;
        }

        public RequestHandlerContext build() {
            return this.product;
        }
    }
}

