/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.a2a.internal.server.agent;

import com.mulesoft.connectors.a2a.api.listener.RequestAttributes;
import com.mulesoft.connectors.a2a.internal.protocol.model.JsonRpcError;
import com.mulesoft.connectors.a2a.internal.protocol.model.JsonRpcRequest;
import com.mulesoft.connectors.a2a.internal.util.A2AUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import org.mule.runtime.api.util.MultiMap;

public class RpcRequestContext {
    private final JsonRpcRequest request;
    private final RequestAttributes requestAttributes;
    private final CompletableFuture<Response> responseFuture = new CompletableFuture();

    public RpcRequestContext(JsonRpcRequest request, RequestAttributes requestAttributes) {
        this.request = request;
        this.requestAttributes = requestAttributes;
    }

    public JsonRpcRequest getRequest() {
        return this.request;
    }

    public RequestAttributes getRequestAttributes() {
        return this.requestAttributes;
    }

    public CompletableFuture<Response> getResponseFuture() {
        return this.responseFuture;
    }

    public static class Response {
        private int statusCode = 200;
        private InputStream body;
        private JsonRpcError error;
        private MultiMap<String, String> headers = new MultiMap();

        Response() {
        }

        public static Builder builder() {
            return new Builder();
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public InputStream getBody() {
            return this.body;
        }

        public MultiMap<String, String> getHeaders() {
            return this.headers;
        }

        public JsonRpcError getError() {
            return this.error;
        }

        void setStatusCode(int statusCode) {
            this.statusCode = statusCode;
        }

        void setBody(String body) {
            this.body = new ByteArrayInputStream(body.getBytes());
        }

        void setHeaders(MultiMap<String, String> responseHeaders) {
            this.headers = A2AUtils.copy(responseHeaders);
        }

        void setError(JsonRpcError error) {
            this.error = error;
        }

        public static class Builder {
            private final Response response = new Response();

            private Builder() {
            }

            public Builder statusCode(int statusCode) {
                this.response.statusCode = statusCode;
                return this;
            }

            public Builder body(InputStream body) {
                this.response.body = body;
                return this;
            }

            public Builder error(JsonRpcError error) {
                this.response.error = error;
                return this;
            }

            public Builder headers(MultiMap<String, String> headers) {
                this.response.headers = A2AUtils.copy(headers);
                return this;
            }

            public Response build() {
                return this.response;
            }
        }
    }
}

