/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.a2a.internal.server.agent.operations;

import com.mulesoft.connectors.a2a.internal.protocol.model.JsonRpcRequest;
import com.mulesoft.connectors.a2a.internal.server.agent.RequestHandlerContext;
import com.mulesoft.connectors.a2a.internal.server.agent.RpcRequestContext;
import com.mulesoft.connectors.a2a.internal.server.agent.operations.RequestHandler;
import com.mulesoft.connectors.a2a.internal.server.agent.push.EffectivePushNotificationConfig;
import com.mulesoft.connectors.a2a.internal.server.agent.repository.TaskRepository;
import com.mulesoft.connectors.a2a.internal.server.agent.repository.TaskRepositoryItem;
import com.mulesoft.connectors.a2a.internal.server.agent.utils.HandlerUtils;
import java.io.ByteArrayInputStream;
import java.util.List;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.http.api.HttpConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeletePushNotificationConfigHandler
extends RequestHandler {
    public static final Logger LOGGER = LoggerFactory.getLogger(DeletePushNotificationConfigHandler.class);

    @Override
    public void execute(RequestHandlerContext requestHandlerContext) {
        LOGGER.debug("Got request to delete pushNotificationConfig for task...");
        RpcRequestContext context = requestHandlerContext.getRpcRequestContext();
        JsonRpcRequest rpcRequest = context.getRequest();
        HandlerUtils.setupResponseHandler(requestHandlerContext);
        if (!requestHandlerContext.getAgentCard().getCapabilities().isPushNotifications()) {
            HandlerUtils.handlePushNotificationNotSupported(context);
            return;
        }
        String taskId = HandlerUtils.getTaskIdFromPushConfigRequest(requestHandlerContext.getA2aSerializer(), rpcRequest);
        String pushNotificationConfigId = HandlerUtils.getPushConfigIdFromPushConfigRequest(requestHandlerContext.getA2aSerializer(), rpcRequest);
        try {
            LOGGER.debug("Retrieving task from history - taskId: {}", (Object)taskId);
            TaskRepository taskRepository = requestHandlerContext.getTaskRepository();
            taskRepository.apply(taskId, () -> taskRepository.get(taskId).ifPresentOrElse(item -> {
                LOGGER.debug("Task found in history - taskId: {}", (Object)taskId);
                this.deletePushNotificationConfigs(requestHandlerContext, (TaskRepositoryItem)item, taskId, pushNotificationConfigId);
            }, () -> HandlerUtils.handleTaskNotFound(context)));
        }
        catch (ObjectStoreException e) {
            LOGGER.error("ObjectStore failed to retrieve task with id: {}", (Object)taskId, (Object)e);
            HandlerUtils.handleInternalError(context, e);
        }
    }

    public void deletePushNotificationConfigs(RequestHandlerContext requestHandlerContext, TaskRepositoryItem item, String taskId, String pushNotificationConfigId) {
        try {
            List<EffectivePushNotificationConfig> pushNotificationConfigs = item.getPushNotificationConfigs();
            List<EffectivePushNotificationConfig> updatedPushNotificationConfigs = pushNotificationConfigs.stream().filter(config -> !config.getId().equals(pushNotificationConfigId)).toList();
            item.setPushNotificationConfigs(updatedPushNotificationConfigs);
            requestHandlerContext.getTaskRepository().upsert(taskId, item);
            RpcRequestContext.Response successResponse = RpcRequestContext.Response.builder().statusCode(HttpConstants.HttpStatus.OK.getStatusCode()).body(new ByteArrayInputStream("[]".getBytes())).build();
            requestHandlerContext.getRpcRequestContext().getResponseFuture().complete(successResponse);
        }
        catch (Exception e) {
            LOGGER.error("Failed to transform task history response", (Throwable)e);
            HandlerUtils.handleInternalError(requestHandlerContext.getRpcRequestContext(), e);
        }
    }
}

