/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.a2a.internal.server.agent.operations;

import com.mulesoft.connectors.a2a.internal.error.A2AErrorTypes;
import com.mulesoft.connectors.a2a.internal.protocol.model.JsonRpcError;
import com.mulesoft.connectors.a2a.internal.protocol.model.JsonRpcRequest;
import com.mulesoft.connectors.a2a.internal.server.agent.RequestHandlerContext;
import com.mulesoft.connectors.a2a.internal.server.agent.RpcRequestContext;
import com.mulesoft.connectors.a2a.internal.server.agent.operations.RequestHandler;
import com.mulesoft.connectors.a2a.internal.server.agent.repository.TaskRepositoryItem;
import com.mulesoft.connectors.a2a.internal.server.agent.request.TaskQueryParams;
import com.mulesoft.connectors.a2a.internal.server.agent.response.JsonRpcResult;
import com.mulesoft.connectors.a2a.internal.server.agent.utils.HandlerUtils;
import java.io.ByteArrayInputStream;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.http.api.HttpConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetRequestHandler
extends RequestHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(GetRequestHandler.class);
    private static final String INVALID_PARAMS_MESSAGE = "Invalid method parameters";
    private static final String TASK_NOT_FOUND_MESSAGE = "Task not found";
    private static final String INTERNAL_ERROR_MESSAGE = "Internal error";

    @Override
    public void execute(RequestHandlerContext handlerContext) {
        RpcRequestContext rpcContext = handlerContext.getRpcRequestContext();
        JsonRpcRequest rpcRequest = rpcContext.getRequest();
        LOGGER.debug("Processing tasks/get request - requestId: {}", rpcRequest.getId());
        JsonRpcResult result = handlerContext.getA2aSerializer().getTaskQueryParams(rpcRequest.getParams());
        String taskId = null;
        Integer historyLength = null;
        Object object = result.getResult();
        if (object instanceof TaskQueryParams) {
            TaskQueryParams taskQueryParams = (TaskQueryParams)object;
            taskId = taskQueryParams.getId();
            historyLength = taskQueryParams.getHistoryLength();
        }
        if (taskId == null || taskId.trim().isEmpty()) {
            this.handleInvalidParams(rpcContext);
        } else {
            try {
                this.processTaskRequest(handlerContext, rpcContext, taskId, historyLength);
            }
            catch (Exception e) {
                LOGGER.error("Failed to process task request - taskId: {}", (Object)taskId, (Object)e);
                this.handleInternalError(rpcContext);
            }
        }
        HandlerUtils.setupResponseHandler(handlerContext);
    }

    private void processTaskRequest(RequestHandlerContext context, RpcRequestContext rpcContext, String taskId, int historyLength) {
        try {
            context.getTaskRepository().get(taskId).ifPresentOrElse(item -> this.handleTaskFound(context, rpcContext, (TaskRepositoryItem)item, historyLength), () -> this.handleTaskNotFound(rpcContext));
        }
        catch (ObjectStoreException e) {
            LOGGER.error("ObjectStore operation failed while retrieving task - taskId: {}", (Object)taskId, (Object)e);
            this.handleInternalError(rpcContext);
        }
    }

    private void handleTaskFound(RequestHandlerContext context, RpcRequestContext rpcContext, TaskRepositoryItem taskRepositoryItem, int historyLength) {
        try {
            String taskHistoryJson = taskRepositoryItem.getTaskJson();
            String transformedResponse = context.getA2aSerializer().transformTaskHistoryResponse(taskHistoryJson, historyLength);
            RpcRequestContext.Response successResponse = this.createSuccessResponse(transformedResponse);
            rpcContext.getResponseFuture().complete(successResponse);
        }
        catch (Exception e) {
            LOGGER.error("Failed to transform task history response", (Throwable)e);
            this.handleInternalError(rpcContext);
        }
    }

    private RpcRequestContext.Response createSuccessResponse(String transformedResponse) {
        return RpcRequestContext.Response.builder().statusCode(HttpConstants.HttpStatus.OK.getStatusCode()).body(new ByteArrayInputStream(transformedResponse.getBytes())).build();
    }

    private void handleInvalidParams(RpcRequestContext context) {
        JsonRpcError error = new JsonRpcError(A2AErrorTypes.INVALID_PARAMS.getJsonRpcCode().get(), INVALID_PARAMS_MESSAGE);
        RpcRequestContext.Response errorResponse = RpcRequestContext.Response.builder().statusCode(HttpConstants.HttpStatus.BAD_REQUEST.getStatusCode()).error(error).build();
        context.getResponseFuture().complete(errorResponse);
    }

    private void handleTaskNotFound(RpcRequestContext context) {
        JsonRpcError error = new JsonRpcError(A2AErrorTypes.TASK_NOT_FOUND.getJsonRpcCode().get(), TASK_NOT_FOUND_MESSAGE);
        RpcRequestContext.Response errorResponse = RpcRequestContext.Response.builder().statusCode(HttpConstants.HttpStatus.NOT_FOUND.getStatusCode()).error(error).build();
        context.getResponseFuture().complete(errorResponse);
    }

    private void handleInternalError(RpcRequestContext context) {
        JsonRpcError error = new JsonRpcError(A2AErrorTypes.INTERNAL_ERROR.getJsonRpcCode().get(), INTERNAL_ERROR_MESSAGE);
        RpcRequestContext.Response errorResponse = RpcRequestContext.Response.builder().statusCode(HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR.getStatusCode()).error(error).build();
        context.getResponseFuture().complete(errorResponse);
    }
}

