/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.a2a.internal.server.agent.operations;

import com.mulesoft.connectors.a2a.internal.error.A2AErrorTypes;
import com.mulesoft.connectors.a2a.internal.protocol.A2AProtocolSerializer;
import com.mulesoft.connectors.a2a.internal.protocol.model.JsonRpcRequest;
import com.mulesoft.connectors.a2a.internal.server.agent.RequestHandlerContext;
import com.mulesoft.connectors.a2a.internal.server.agent.RpcRequestContext;
import com.mulesoft.connectors.a2a.internal.server.agent.operations.RequestHandler;
import com.mulesoft.connectors.a2a.internal.server.agent.push.EffectivePushNotificationConfig;
import com.mulesoft.connectors.a2a.internal.server.agent.repository.TaskRepository;
import com.mulesoft.connectors.a2a.internal.server.agent.repository.TaskRepositoryItem;
import com.mulesoft.connectors.a2a.internal.server.agent.repository.TaskStoreService;
import com.mulesoft.connectors.a2a.internal.server.agent.response.JsonRpcResult;
import com.mulesoft.connectors.a2a.internal.server.agent.response.TaskObject;
import com.mulesoft.connectors.a2a.internal.server.agent.utils.ServerAgentUtils;
import com.mulesoft.connectors.a2a.internal.util.A2AUtils;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import org.mule.extension.http.api.request.authentication.HttpRequestAuthentication;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.client.HttpRequestOptionsBuilder;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;
import org.mule.runtime.http.api.client.proxy.ProxyConfig;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendMessageHandler
extends RequestHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SendMessageHandler.class);
    private static final String NOTIFICATION_TOKEN_HEADER = "X-A2A-Notification-Token";
    private final boolean taskHistoryEnabled;
    private final HttpClient httpClient;

    public SendMessageHandler(boolean taskHistoryEnabled, HttpClient httpClient) {
        this.taskHistoryEnabled = taskHistoryEnabled;
        this.httpClient = httpClient;
    }

    @Override
    public void execute(RequestHandlerContext handlerContext) {
        boolean isPushConfigInRequest;
        RpcRequestContext rpcContext = handlerContext.getRpcRequestContext();
        JsonRpcRequest rpcRequest = handlerContext.getRpcRequestContext().getRequest();
        CompletableFuture pushConfigFuture = new CompletableFuture();
        boolean pushEnabled = handlerContext.getAgentCard().getCapabilities().isPushNotifications();
        try {
            isPushConfigInRequest = this.isPushNotificationConfigPresent(rpcRequest.getParams(), handlerContext);
        }
        catch (Exception e) {
            ServerAgentUtils.sendFailureHttpResponse(HttpConstants.HttpStatus.BAD_REQUEST.getStatusCode(), A2AErrorTypes.INVALID_REQUEST, e.getMessage(), rpcRequest, handlerContext.getResponseCallback(), handlerContext.getRpcSerializer());
            return;
        }
        if (!pushEnabled && isPushConfigInRequest) {
            ServerAgentUtils.sendFailureHttpResponse(HttpConstants.HttpStatus.BAD_REQUEST.getStatusCode(), A2AErrorTypes.PUSH_NOTIFICATION_UNSUPPORTED, "This agent doesn't support push notifications!", rpcRequest, handlerContext.getResponseCallback(), handlerContext.getRpcSerializer());
            return;
        }
        if (pushEnabled && isPushConfigInRequest) {
            handlerContext.getSetPushNotificationConfigHandler().apply(rpcContext).whenComplete((pushConfig, t) -> {
                if (t != null) {
                    LOGGER.warn("Push notification config rejected for taskId: {}", (Object)rpcContext.getRequestAttributes().getTaskId(), t);
                    ServerAgentUtils.sendFailureHttpResponse(HttpConstants.HttpStatus.BAD_REQUEST.getStatusCode(), A2AErrorTypes.INVALID_REQUEST, "Push notification config rejected: " + t.getMessage(), rpcRequest, handlerContext.getResponseCallback(), handlerContext.getRpcSerializer());
                    pushConfigFuture.completeExceptionally((Throwable)t);
                } else {
                    try {
                        String taskId = rpcContext.getRequestAttributes().getTaskId();
                        TaskRepository taskRepository = handlerContext.getTaskRepository();
                        taskRepository.apply(taskId, () -> {
                            TaskRepositoryItem existingItem = taskRepository.get(taskId).orElse(new TaskRepositoryItem());
                            existingItem.addPushNotificationConfig((EffectivePushNotificationConfig)pushConfig);
                            taskRepository.upsert(taskId, existingItem);
                        });
                        ServerAgentUtils.sendSubmittedAcceptedResponse(rpcRequest, handlerContext.getResponseCallback(), handlerContext.getRpcSerializer(), taskId);
                        pushConfigFuture.complete(null);
                    }
                    catch (ObjectStoreException e) {
                        LOGGER.error("Failed to store push notification config for taskId: {}", (Object)rpcContext.getRequestAttributes().getTaskId(), (Object)e);
                        ServerAgentUtils.sendExceptionalHttpResponse(rpcRequest, e, handlerContext.getResponseCallback(), handlerContext.getRpcSerializer());
                        pushConfigFuture.completeExceptionally(e);
                    }
                }
            });
        } else {
            pushConfigFuture.complete(null);
        }
        pushConfigFuture.thenAccept(Void2 -> {
            this.updateTaskHistoryWithRequestMessage(handlerContext);
            handlerContext.getMessageHandler().accept(rpcContext);
            rpcContext.getResponseFuture().whenComplete((response, t) -> {
                block10: {
                    String taskId = rpcContext.getRequestAttributes().getTaskId();
                    EffectivePushNotificationConfig pushConfig = null;
                    if (isPushConfigInRequest && pushEnabled) {
                        pushConfig = this.getPushNotificationConfig(handlerContext, taskId);
                    }
                    if (t != null) {
                        if (pushConfig == null) {
                            ServerAgentUtils.sendExceptionalHttpResponse(rpcRequest, t, handlerContext.getResponseCallback(), handlerContext.getRpcSerializer());
                        } else {
                            String responseBody = ServerAgentUtils.getExceptionalResponse(rpcRequest, t, handlerContext.getRpcSerializer());
                            this.pushNotificationCallback(responseBody, pushConfig, taskId, handlerContext);
                        }
                    } else {
                        String responseBody = ServerAgentUtils.createResponseBody(rpcRequest, response, handlerContext.getRpcSerializer());
                        if (response.getStatusCode() == 200 && this.taskHistoryEnabled) {
                            this.updateTaskHistoryWithResponseMessage(handlerContext, responseBody);
                        }
                        try {
                            if (pushConfig != null) {
                                this.pushNotificationCallback(responseBody, pushConfig, taskId, handlerContext);
                            } else {
                                ServerAgentUtils.sendHttpResponse(response.getStatusCode(), responseBody, response.getHeaders(), handlerContext.getResponseCallback());
                            }
                        }
                        catch (Exception e) {
                            if (pushConfig != null) break block10;
                            ServerAgentUtils.sendExceptionalHttpResponse(rpcRequest, e, handlerContext.getResponseCallback(), handlerContext.getRpcSerializer());
                        }
                    }
                }
            });
        });
    }

    private EffectivePushNotificationConfig getPushNotificationConfig(RequestHandlerContext handlerContext, String taskId) {
        EffectivePushNotificationConfig pushConfig = null;
        try {
            TaskRepositoryItem item = handlerContext.getTaskRepository().get(taskId).orElse(null);
            if (item != null && item.getPushNotificationConfigs() != null) {
                int totalPushConfigs = item.getPushNotificationConfigs().size();
                pushConfig = item.getPushNotificationConfigs().get(totalPushConfigs - 1);
            }
        }
        catch (ObjectStoreException e) {
            LOGGER.error("Failed to retrieve push notification config for taskId from object store: {}", (Object)taskId, (Object)e);
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Failed to retrieve push notification config for taskId " + taskId + " from object store")), (Throwable)e);
        }
        return pushConfig;
    }

    private void updateTaskHistoryWithRequestMessage(RequestHandlerContext handlerContext) {
        A2AProtocolSerializer a2aSerializer = handlerContext.getA2aSerializer();
        try {
            String requestMessage = a2aSerializer.getJsonMessageFromRequest(handlerContext.getRpcRequestContext().getRequest().getParams());
            String taskId = handlerContext.getRpcRequestContext().getRequestAttributes().getTaskId();
            TaskStoreService taskStoreService = handlerContext.getTaskStoreService();
            taskStoreService.updateHistory(taskId, requestMessage);
        }
        catch (ObjectStoreException e) {
            LOGGER.error("Error updating task history with request message due to object store failure", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("Error updating task history with request message due to unexpected error", (Throwable)e);
        }
    }

    private void updateTaskHistoryWithResponseMessage(RequestHandlerContext handlerContext, String responseBody) {
        A2AProtocolSerializer a2aSerializer = handlerContext.getA2aSerializer();
        try {
            JsonRpcResult result = a2aSerializer.parseResult(responseBody);
            String responseMessage = a2aSerializer.getJsonMessageFromResult(responseBody);
            String taskId = handlerContext.getRpcRequestContext().getRequestAttributes().getTaskId();
            if (null == result.getResult()) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Response was neither of kind 'task' nor 'message'! Ensure that 'kind' field is returned in the response."));
            }
            TaskStoreService taskStoreService = handlerContext.getTaskStoreService();
            Object object = result.getResult();
            if (object instanceof TaskObject) {
                TaskObject taskObject = (TaskObject)object;
                taskStoreService.updateTask(taskId, result.getResultJson());
                taskStoreService.updateHistory(taskId, responseMessage);
            } else {
                taskStoreService.updateHistory(taskId, responseMessage);
            }
        }
        catch (ObjectStoreException e) {
            LOGGER.error("Error updating task history with response message due to object store failure", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("Error updating task history with response message due to unexpected error", (Throwable)e);
        }
    }

    private void pushNotificationCallback(String body, EffectivePushNotificationConfig config, String taskId, RequestHandlerContext handlerContext) {
        try {
            HttpRequestBuilder requestBuilder;
            HttpRequestOptionsBuilder optionsBuilder = HttpRequestOptions.builder().responseTimeout(config.getTimeout()).proxyConfig((ProxyConfig)config.getProxyConfig());
            HttpRequestAuthentication httpRequestAuthentication = config.getAuthentication();
            if (httpRequestAuthentication instanceof HttpAuthentication) {
                HttpAuthentication auth = (HttpAuthentication)httpRequestAuthentication;
                optionsBuilder.authentication(auth);
                requestBuilder = A2AUtils.newRequestBuilder(null);
            } else {
                requestBuilder = A2AUtils.newRequestBuilder(config.getAuthentication());
            }
            ByteArrayHttpEntity httpEntity = new ByteArrayHttpEntity(body.getBytes(StandardCharsets.UTF_8));
            ((HttpRequestBuilder)requestBuilder.uri(config.getUrl()).method("POST").addHeader("Content-Type", "application/json")).entity((HttpEntity)httpEntity);
            if (!StringUtils.isBlank((String)config.getToken())) {
                requestBuilder.addHeader(NOTIFICATION_TOKEN_HEADER, config.getToken());
            }
            if (null != config.getAdditionalHeaders()) {
                config.getAdditionalHeaders().forEach((arg_0, arg_1) -> ((HttpRequestBuilder)requestBuilder).addHeader(arg_0, arg_1));
            }
            this.httpClient.sendAsync(requestBuilder.build(), optionsBuilder.build()).whenComplete((httpResponse, error) -> {
                if (error != null) {
                    LOGGER.error("Push notification callback failed: {}", (Object)error.getMessage(), error);
                } else {
                    try {
                        IOUtils.toByteArray((InputStream)httpResponse.getEntity().getContent());
                    }
                    catch (Exception e) {
                        LOGGER.warn("Callback succeeded but failed to read response", (Throwable)e);
                    }
                    this.clearPushNotificationConfig(taskId, handlerContext);
                }
            });
        }
        catch (Exception e) {
            LOGGER.error("Error in triggering notification callback for taskId: {}", (Object)taskId, (Object)e);
        }
    }

    private void clearPushNotificationConfig(String taskId, RequestHandlerContext handlerContext) {
        try {
            TaskRepository taskRepository = handlerContext.getTaskRepository();
            if (taskRepository != null) {
                taskRepository.apply(taskId, () -> {
                    TaskRepositoryItem existingItem = taskRepository.get(taskId).orElse(new TaskRepositoryItem());
                    existingItem.clearPushNotificationConfigs();
                    taskRepository.upsert(taskId, existingItem);
                });
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to clear push notification config for taskId: {}", (Object)taskId, (Object)e);
        }
    }

    private boolean isPushNotificationConfigPresent(String paramsJson, RequestHandlerContext handlerContext) {
        try {
            String extractedConfig = handlerContext.getA2aSerializer().extractPushNotificationConfigJson(paramsJson);
            return extractedConfig != null && !extractedConfig.trim().isEmpty() && !extractedConfig.equals("null");
        }
        catch (Exception e) {
            LOGGER.error("Failed to extract push notification config from request ", (Throwable)e);
            throw new IllegalArgumentException("Failed to extract push notification config from request: ", e);
        }
    }
}

