/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.a2a.internal.server.agent.operations;

import com.mulesoft.connectors.a2a.internal.error.A2AErrorTypes;
import com.mulesoft.connectors.a2a.internal.protocol.model.JsonRpcError;
import com.mulesoft.connectors.a2a.internal.protocol.model.JsonRpcRequest;
import com.mulesoft.connectors.a2a.internal.server.agent.RequestHandlerContext;
import com.mulesoft.connectors.a2a.internal.server.agent.RpcRequestContext;
import com.mulesoft.connectors.a2a.internal.server.agent.operations.RequestHandler;
import com.mulesoft.connectors.a2a.internal.server.agent.push.EffectivePushNotificationConfig;
import com.mulesoft.connectors.a2a.internal.server.agent.repository.TaskRepository;
import com.mulesoft.connectors.a2a.internal.server.agent.repository.TaskRepositoryItem;
import com.mulesoft.connectors.a2a.internal.server.agent.utils.ServerAgentUtils;
import java.io.ByteArrayInputStream;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.http.api.HttpConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetPushNotificationConfigHandler
extends RequestHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SetPushNotificationConfigHandler.class);
    private static final String INVALID_PARAMS_MESSAGE = "TaskId is required but missing for push notification config set method";
    private static final String PUSH_CONFIG_REJECTED_MESSAGE = "Push notification config rejected";
    private static final String INTERNAL_ERROR_MESSAGE = "Failed to save push notification config";

    @Override
    public void execute(RequestHandlerContext handlerContext) {
        RpcRequestContext rpcContext = handlerContext.getRpcRequestContext();
        if (!handlerContext.getAgentCard().getCapabilities().isPushNotifications()) {
            ServerAgentUtils.sendFailureHttpResponse(HttpConstants.HttpStatus.BAD_REQUEST.getStatusCode(), A2AErrorTypes.PUSH_NOTIFICATION_UNSUPPORTED, "This agent doesn't support push notifications!", rpcContext.getRequest(), handlerContext.getResponseCallback(), handlerContext.getRpcSerializer());
            return;
        }
        String taskId = rpcContext.getRequestAttributes().getTaskId();
        if (taskId == null || taskId.trim().isEmpty()) {
            LOGGER.error(INVALID_PARAMS_MESSAGE);
            this.handleInvalidParams(rpcContext);
            return;
        }
        this.setupResponseHandler(handlerContext, rpcContext);
        handlerContext.getSetPushNotificationConfigHandler().apply(rpcContext).whenComplete((pushConfig, t) -> {
            if (t != null) {
                LOGGER.warn("Push notification config rejected for taskId: {}", (Object)taskId, t);
                this.handlePushConfigRejected(rpcContext, t.getMessage());
            } else {
                try {
                    this.processPushNotificationConfig(handlerContext, rpcContext, taskId, (EffectivePushNotificationConfig)pushConfig);
                }
                catch (Exception e) {
                    LOGGER.error("Failed to process push notification config for taskId: {}", (Object)taskId, (Object)e);
                    this.handleInternalError(rpcContext);
                }
            }
        });
    }

    private void processPushNotificationConfig(RequestHandlerContext context, RpcRequestContext rpcContext, String taskId, EffectivePushNotificationConfig pushConfig) {
        try {
            TaskRepository taskRepository = context.getTaskRepository();
            taskRepository.apply(taskId, () -> {
                TaskRepositoryItem existingItem = taskRepository.get(taskId).orElse(new TaskRepositoryItem());
                existingItem.addPushNotificationConfig(pushConfig);
                taskRepository.upsert(taskId, existingItem);
            });
            String transformedResponse = context.getA2aSerializer().transformPushNotificationConfigResponse(taskId, pushConfig);
            RpcRequestContext.Response successResponse = this.createSuccessResponse(transformedResponse);
            rpcContext.getResponseFuture().complete(successResponse);
        }
        catch (ObjectStoreException e) {
            LOGGER.error("Failed to save push notification config for taskId: {}", (Object)taskId, (Object)e);
            this.handleInternalError(rpcContext);
        }
    }

    private RpcRequestContext.Response createSuccessResponse(String transformedResponse) {
        return RpcRequestContext.Response.builder().statusCode(HttpConstants.HttpStatus.OK.getStatusCode()).body(new ByteArrayInputStream(transformedResponse.getBytes())).build();
    }

    private void handleInvalidParams(RpcRequestContext context) {
        JsonRpcError error = new JsonRpcError(-32602, INVALID_PARAMS_MESSAGE);
        RpcRequestContext.Response errorResponse = RpcRequestContext.Response.builder().statusCode(HttpConstants.HttpStatus.BAD_REQUEST.getStatusCode()).error(error).build();
        context.getResponseFuture().complete(errorResponse);
    }

    private void handlePushConfigRejected(RpcRequestContext context, String reason) {
        JsonRpcError error = new JsonRpcError(-32602, "Push notification config rejected: " + reason);
        RpcRequestContext.Response errorResponse = RpcRequestContext.Response.builder().statusCode(HttpConstants.HttpStatus.BAD_REQUEST.getStatusCode()).error(error).build();
        context.getResponseFuture().complete(errorResponse);
    }

    private void handleInternalError(RpcRequestContext context) {
        JsonRpcError error = new JsonRpcError(-32603, INTERNAL_ERROR_MESSAGE);
        RpcRequestContext.Response errorResponse = RpcRequestContext.Response.builder().statusCode(HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR.getStatusCode()).error(error).build();
        context.getResponseFuture().complete(errorResponse);
    }

    private void setupResponseHandler(RequestHandlerContext context, RpcRequestContext rpcContext) {
        rpcContext.getResponseFuture().whenComplete((response, throwable) -> {
            if (throwable != null) {
                LOGGER.error("Unexpected error in response future - requestId: {}", rpcContext.getRequest().getId(), throwable);
                ServerAgentUtils.sendExceptionalHttpResponse(rpcContext.getRequest(), throwable, context.getResponseCallback(), context.getRpcSerializer());
            } else {
                this.sendSuccessfulResponse(context, (RpcRequestContext.Response)response);
            }
        });
    }

    private void sendSuccessfulResponse(RequestHandlerContext context, RpcRequestContext.Response response) {
        JsonRpcRequest rpcRequest = context.getRpcRequestContext().getRequest();
        try {
            if (response.getError() != null) {
                String responseBody = context.getRpcSerializer().writeJsonErrorResponse(rpcRequest.getId(), response.getError().getCode(), response.getError().getMessage());
                ServerAgentUtils.sendHttpResponse(response.getStatusCode(), responseBody, response.getHeaders(), context.getResponseCallback());
            } else {
                String responseBody = context.getRpcSerializer().writeJsonResponse(rpcRequest.getId(), response.getBody());
                ServerAgentUtils.sendHttpResponse(response.getStatusCode(), responseBody, response.getHeaders(), context.getResponseCallback());
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to send HTTP response - requestId: {}", rpcRequest.getId(), (Object)e);
            ServerAgentUtils.sendExceptionalHttpResponse(rpcRequest, e, context.getResponseCallback(), context.getRpcSerializer());
        }
    }
}

