/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.a2a.internal.server.agent.repository;

import com.mulesoft.connectors.a2a.internal.server.agent.repository.TaskRepository;
import com.mulesoft.connectors.a2a.internal.server.agent.repository.TaskRepositoryItem;
import com.mulesoft.connectors.a2a.internal.server.agent.repository.TaskStoreService;
import com.mulesoft.connectors.a2a.internal.server.agent.utils.JsonUtils;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import org.mule.runtime.api.store.ObjectStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTaskStoreServiceImpl
implements TaskStoreService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultTaskStoreServiceImpl.class);
    public static final String TASK_FIELD = "task";
    public static final String HISTORY_FIELD = "history";
    public static final String HISTORY_FIELD_LENGTH = "historyLength";
    private final TaskRepository taskRepository;

    public DefaultTaskStoreServiceImpl(TaskRepository taskRepository) {
        this.taskRepository = taskRepository;
    }

    @Override
    public void updateHistory(String taskId, String historyObj) throws ObjectStoreException {
        this.taskRepository.apply(taskId, () -> {
            TaskRepositoryItem repositoryItem = this.taskRepository.get(taskId).orElse(new TaskRepositoryItem());
            JsonObject existingJson = repositoryItem.getTaskJson() != null ? JsonUtils.parseJsonObject(repositoryItem.getTaskJson()) : Json.createObjectBuilder().build();
            JsonObjectBuilder newTaskBuilder = this.buildBaseTaskJson(existingJson);
            JsonArray updatedHistory = this.mergeJsonArray(existingJson.getJsonArray(HISTORY_FIELD), JsonUtils.parseJsonObject(historyObj));
            newTaskBuilder.add(HISTORY_FIELD, (JsonValue)updatedHistory);
            newTaskBuilder.add(HISTORY_FIELD_LENGTH, updatedHistory.size());
            this.saveTaskJson(taskId, newTaskBuilder.build(), HISTORY_FIELD, repositoryItem);
        });
    }

    @Override
    public void updateTask(String taskId, String taskObj) throws ObjectStoreException {
        this.taskRepository.apply(taskId, () -> {
            TaskRepositoryItem repositoryItem = this.taskRepository.get(taskId).orElse(new TaskRepositoryItem());
            JsonObject existingJson = repositoryItem.getTaskJson() != null ? JsonUtils.parseJsonObject(repositoryItem.getTaskJson()) : Json.createObjectBuilder().build();
            JsonObjectBuilder newTaskBuilder = this.buildBaseTaskJson(existingJson);
            newTaskBuilder.add(TASK_FIELD, (JsonValue)JsonUtils.parseJsonObject(taskObj));
            this.saveTaskJson(taskId, newTaskBuilder.build(), TASK_FIELD, repositoryItem);
        });
    }

    private JsonObjectBuilder buildBaseTaskJson(JsonObject existing) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        if (existing.containsKey((Object)HISTORY_FIELD_LENGTH)) {
            builder.add(HISTORY_FIELD_LENGTH, existing.getInt(HISTORY_FIELD_LENGTH));
        }
        if (existing.containsKey((Object)HISTORY_FIELD)) {
            builder.add(HISTORY_FIELD, (JsonValue)existing.getJsonArray(HISTORY_FIELD));
        } else {
            builder.add(HISTORY_FIELD, (JsonValue)Json.createArrayBuilder().build());
        }
        if (existing.containsKey((Object)TASK_FIELD)) {
            builder.add(TASK_FIELD, (JsonValue)existing.getJsonObject(TASK_FIELD));
        }
        return builder;
    }

    private JsonArray mergeJsonArray(JsonArray existingArray, JsonObject newElement) {
        JsonArrayBuilder builder = Json.createArrayBuilder();
        if (existingArray != null) {
            existingArray.forEach(arg_0 -> ((JsonArrayBuilder)builder).add(arg_0));
        }
        builder.add((JsonValue)newElement);
        return builder.build();
    }

    private void saveTaskJson(String taskId, JsonObject newTaskDetails, String fieldName, TaskRepositoryItem item) throws ObjectStoreException {
        String taskJson = JsonUtils.writeJsonObjectToString(newTaskDetails);
        item.setTaskJson(taskJson);
        LOGGER.debug("Updated taskJson field '{}' for taskId '{}'", (Object)fieldName, (Object)taskId);
        this.taskRepository.upsert(taskId, item);
    }
}

