/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.a2a.internal.server.agent.utils;

import com.mulesoft.connectors.a2a.internal.error.A2AErrorTypes;
import com.mulesoft.connectors.a2a.internal.protocol.A2AProtocolSerializer;
import com.mulesoft.connectors.a2a.internal.protocol.model.JsonRpcError;
import com.mulesoft.connectors.a2a.internal.protocol.model.JsonRpcRequest;
import com.mulesoft.connectors.a2a.internal.server.agent.RequestHandlerContext;
import com.mulesoft.connectors.a2a.internal.server.agent.RpcRequestContext;
import com.mulesoft.connectors.a2a.internal.server.agent.request.TaskIdParams;
import com.mulesoft.connectors.a2a.internal.server.agent.request.TaskQueryParams;
import com.mulesoft.connectors.a2a.internal.server.agent.response.JsonRpcResult;
import com.mulesoft.connectors.a2a.internal.server.agent.utils.ServerAgentUtils;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.server.async.HttpResponseReadyCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandlerUtils {
    public static final Logger LOGGER = LoggerFactory.getLogger(HandlerUtils.class);
    private static final String INVALID_PARAMS_MESSAGE = "Invalid method parameters";
    private static final String TASK_NOT_FOUND_MESSAGE = "Task not found";
    private static final String PUSH_NOTIFICATION_UNSUPPORTED_MESSAGE = "Push notification not supported for this agent!";
    private static final String INTERNAL_ERROR_MESSAGE = "Internal error";

    public static void handleTaskNotFound(RpcRequestContext context) {
        JsonRpcError error = new JsonRpcError(A2AErrorTypes.TASK_NOT_FOUND.getJsonRpcCode().get(), TASK_NOT_FOUND_MESSAGE);
        RpcRequestContext.Response errorResponse = RpcRequestContext.Response.builder().statusCode(HttpConstants.HttpStatus.NOT_FOUND.getStatusCode()).error(error).build();
        context.getResponseFuture().complete(errorResponse);
    }

    public static void handlePushNotificationNotSupported(RpcRequestContext context) {
        JsonRpcError error = new JsonRpcError(A2AErrorTypes.PUSH_NOTIFICATION_UNSUPPORTED.getJsonRpcCode().get(), PUSH_NOTIFICATION_UNSUPPORTED_MESSAGE);
        RpcRequestContext.Response errorResponse = RpcRequestContext.Response.builder().statusCode(HttpConstants.HttpStatus.NOT_FOUND.getStatusCode()).error(error).build();
        context.getResponseFuture().complete(errorResponse);
    }

    public static void handleInternalError(RpcRequestContext context) {
        JsonRpcError error = new JsonRpcError(A2AErrorTypes.INTERNAL_ERROR.getJsonRpcCode().get(), INTERNAL_ERROR_MESSAGE);
        RpcRequestContext.Response errorResponse = RpcRequestContext.Response.builder().statusCode(HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR.getStatusCode()).error(error).build();
        context.getResponseFuture().complete(errorResponse);
    }

    public static void handleInternalError(RpcRequestContext context, Throwable t) {
        JsonRpcError error = new JsonRpcError(A2AErrorTypes.INTERNAL_ERROR.getJsonRpcCode().get(), t.getMessage());
        RpcRequestContext.Response errorResponse = RpcRequestContext.Response.builder().statusCode(HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR.getStatusCode()).error(error).build();
        context.getResponseFuture().complete(errorResponse);
    }

    public static String getTaskIdFromPushConfigRequest(A2AProtocolSerializer serializer, JsonRpcRequest rpcRequest) {
        String string;
        JsonRpcResult result = serializer.getTaskPushNotificationConfigParams(rpcRequest.getParams());
        Object object = result.getResult();
        if (object instanceof TaskQueryParams) {
            TaskQueryParams params = (TaskQueryParams)object;
            string = params.getId();
        } else {
            object = result.getResult();
            if (object instanceof TaskIdParams) {
                TaskIdParams taskIdParams = (TaskIdParams)object;
                string = taskIdParams.getId();
            } else {
                string = null;
            }
        }
        return string;
    }

    public static String getPushConfigIdFromPushConfigRequest(A2AProtocolSerializer serializer, JsonRpcRequest rpcRequest) {
        String string;
        JsonRpcResult result = serializer.getTaskPushNotificationConfigParams(rpcRequest.getParams());
        Object object = result.getResult();
        if (object instanceof TaskQueryParams) {
            TaskQueryParams params = (TaskQueryParams)object;
            string = params.getPushNotificationConfigId();
        } else {
            string = null;
        }
        return string;
    }

    public static void setupResponseHandler(RequestHandlerContext handlerContext) {
        RpcRequestContext rpcRequestContext = handlerContext.getRpcRequestContext();
        JsonRpcRequest rpcRequest = rpcRequestContext.getRequest();
        HttpResponseReadyCallback responseCallback = handlerContext.getResponseCallback();
        handlerContext.getRpcRequestContext().getResponseFuture().whenComplete((response, throwable) -> {
            if (throwable != null) {
                LOGGER.error("Unexpected error in response future - requestId: {}", rpcRequest.getId(), throwable);
                ServerAgentUtils.sendExceptionalHttpResponse(rpcRequest, throwable, responseCallback, handlerContext.getRpcSerializer());
            } else {
                try {
                    String responseBody = ServerAgentUtils.createResponseBody(rpcRequest, response, handlerContext.getRpcSerializer());
                    ServerAgentUtils.sendHttpResponse(response.getStatusCode(), responseBody, response.getHeaders(), responseCallback);
                }
                catch (Exception e) {
                    LOGGER.error("Failed to send HTTP response - requestId: {}", rpcRequest.getId(), (Object)e);
                    ServerAgentUtils.sendExceptionalHttpResponse(rpcRequest, e, responseCallback, handlerContext.getRpcSerializer());
                }
            }
        });
    }
}

