/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.a2a.internal.server.agent.utils;

import com.mulesoft.connectors.a2a.internal.error.A2AErrorTypes;
import com.mulesoft.connectors.a2a.internal.protocol.JsonRpcSerializer;
import com.mulesoft.connectors.a2a.internal.protocol.model.JsonRpcRequest;
import com.mulesoft.connectors.a2a.internal.server.agent.RpcRequestContext;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.runtime.http.api.server.async.HttpResponseReadyCallback;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerAgentUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerAgentUtils.class);

    private ServerAgentUtils() {
    }

    public static String createResponseBody(JsonRpcRequest request, RpcRequestContext.Response response, JsonRpcSerializer serializer) {
        if (response.getError() != null) {
            return serializer.writeJsonErrorResponse(request.getId(), response.getError().getCode(), response.getError().getMessage());
        }
        return serializer.writeJsonResponse(request.getId(), response.getBody());
    }

    public static void sendHttpResponse(int statusCode, String body, HttpResponseReadyCallback callback) {
        MultiMap defaultResponseHeaders = new MultiMap();
        ServerAgentUtils.sendHttpResponse(statusCode, body, (MultiMap<String, String>)defaultResponseHeaders, callback);
    }

    public static void sendHttpResponse(int statusCode, String body, MultiMap<String, String> responseHeaders, HttpResponseReadyCallback callback) {
        String responseBody = body != null ? body : "";
        ServerAgentUtils.sendHttpResponse(((HttpResponseBuilder)((HttpResponseBuilder)((HttpResponseBuilder)HttpResponse.builder().statusCode(Integer.valueOf(statusCode)).entity((HttpEntity)new ByteArrayHttpEntity(responseBody.getBytes()))).headers(responseHeaders)).addHeader("Content-Type", "application/json")).build(), callback);
    }

    public static void sendExceptionalHttpResponse(JsonRpcRequest request, Throwable t, HttpResponseReadyCallback callback, JsonRpcSerializer serializer) {
        ServerAgentUtils.sendFailureHttpResponse(HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR.getStatusCode(), A2AErrorTypes.INTERNAL_ERROR, t.getMessage(), request, callback, serializer);
    }

    public static void sendFailureHttpResponse(Integer httpStatusCode, A2AErrorTypes errorType, String message, JsonRpcRequest request, HttpResponseReadyCallback callback, JsonRpcSerializer serializer) {
        Integer errorCode = errorType.getJsonRpcCode().orElse(A2AErrorTypes.SERVER_ERROR.getJsonRpcCode().get());
        ServerAgentUtils.sendHttpResponse(httpStatusCode, serializer.writeJsonErrorResponse(request.getId(), errorCode, message), callback);
    }

    public static String getExceptionalResponse(JsonRpcRequest request, Throwable t, JsonRpcSerializer serializer) {
        Integer errorCode = A2AErrorTypes.INTERNAL_ERROR.getJsonRpcCode().orElse(A2AErrorTypes.SERVER_ERROR.getJsonRpcCode().get());
        return serializer.writeJsonErrorResponse(request.getId(), errorCode, t.getMessage());
    }

    public static void sendHttpResponse(HttpResponse response, HttpResponseReadyCallback callback) {
        callback.responseReady(response, new ResponseStatusCallback(){

            public void responseSendFailure(Throwable throwable) {
                LOGGER.error("Failed to send message response", throwable);
            }

            public void responseSendSuccessfully() {
            }
        });
    }

    public static void sendSubmittedAcceptedResponse(JsonRpcRequest request, HttpResponseReadyCallback callback, JsonRpcSerializer serializer, String taskId) {
        String responseBody = serializer.createPushNotificationSubmittedResponse(request.getId().toString(), taskId);
        ServerAgentUtils.sendHttpResponse(202, responseBody, callback);
    }
}

