/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.a2a.internal.util;

import java.io.Serializable;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.function.Function;
import org.mule.runtime.api.exception.ObjectNotFoundException;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.core.api.util.func.CheckedSupplier;

public class ObjectStoreAccessor<T extends Serializable> {
    private final ObjectStore<T> objectStore;
    private final LockFactory lockFactory;
    private final Function<String, String> lockKeyFunction;

    public ObjectStoreAccessor(ObjectStore<T> objectStore, LockFactory lockFactory, Function<String, String> lockKeyFunction) {
        this.objectStore = objectStore;
        this.lockFactory = lockFactory;
        this.lockKeyFunction = lockKeyFunction;
    }

    public void upsert(String id, T item) throws ObjectStoreException {
        this.withLock(id, () -> {
            if (this.objectStore.contains(id)) {
                this.objectStore.remove(id);
            }
            this.objectStore.store(id, item);
            return null;
        });
    }

    public Optional<T> get(String id) throws ObjectNotFoundException, ObjectStoreException {
        return (Optional)this.withLock(id, () -> {
            if (this.objectStore.contains(id)) {
                return Optional.of(this.objectStore.retrieve(id));
            }
            return Optional.empty();
        });
    }

    public void remove(String id) throws ObjectStoreException {
        this.withLock(id, () -> {
            try {
                this.objectStore.remove(id);
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                // empty catch block
            }
            return null;
        });
    }

    private <T> T withLock(String id, CheckedSupplier<T> supplier) throws ObjectStoreException {
        Lock lock = this.lockFactory.createLock(this.lockKeyFunction.apply(id));
        lock.lock();
        try {
            Object object = supplier.get();
            return (T)object;
        }
        catch (Throwable t) {
            Throwable cause = t.getCause();
            if (cause instanceof ObjectStoreException) {
                ObjectStoreException e = (ObjectStoreException)cause;
                throw e;
            }
            throw new ObjectStoreException(cause);
        }
        finally {
            lock.unlock();
        }
    }

    public void close() throws ObjectStoreException {
        this.objectStore.close();
    }
}

