/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.azure.eventhubs.api;

import java.io.Serializable;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;

public class EventAttributes
implements Serializable {
    private String contentType;
    private String correlationId;
    private String messageId;
    private Long sequenceNumber;
    private Long offset;
    private Instant enqueuedTime;
    private transient Map<String, Object> metadata;

    public EventAttributes(String contentType, String correlationId, String messageId, Long sequenceNumber, Long offset, Instant enqueuedTime, Map<String, Object> metadata) {
        this.contentType = contentType;
        this.correlationId = correlationId;
        this.messageId = messageId;
        this.sequenceNumber = sequenceNumber;
        this.offset = offset;
        this.enqueuedTime = enqueuedTime;
        this.metadata = metadata;
    }

    public EventAttributes() {
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public Long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public Long getOffset() {
        return this.offset;
    }

    public Instant getEnqueuedTime() {
        return this.enqueuedTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventAttributes that = (EventAttributes)o;
        return Objects.equals(this.contentType, that.contentType) && Objects.equals(this.correlationId, that.correlationId) && Objects.equals(this.messageId, that.messageId) && Objects.equals(this.sequenceNumber, that.sequenceNumber) && Objects.equals(this.offset, that.offset) && Objects.equals(this.enqueuedTime, that.enqueuedTime);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.correlationId, this.messageId, this.sequenceNumber, this.offset, this.enqueuedTime);
    }

    public static class Builder {
        private String contentType;
        private String correlationId;
        private String messageId;
        private Long sequenceNumber;
        private Long offset;
        private Instant enqueuedTime;
        private Map<String, Object> metadata;

        private Builder() {
        }

        public static Builder newInstance() {
            return new Builder();
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder correlationId(String correlationId) {
            this.correlationId = correlationId;
            return this;
        }

        public Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public Builder sequenceNumber(Long sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            return this;
        }

        public Builder offset(Long offset) {
            this.offset = offset;
            return this;
        }

        public Builder enqueuedTime(Instant enqueuedTime) {
            this.enqueuedTime = enqueuedTime;
            return this;
        }

        public Builder metadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public EventAttributes build() {
            return new EventAttributes(this.contentType, this.correlationId, this.messageId, this.sequenceNumber, this.offset, this.enqueuedTime, this.metadata);
        }
    }
}

