/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.azure.eventhubs.api.connection.provider;

import com.azure.messaging.eventhubs.CheckpointStore;
import com.azure.messaging.eventhubs.EventHubClientBuilder;
import com.azure.messaging.eventhubs.EventHubConsumerClient;
import com.azure.messaging.eventhubs.EventProcessorClientBuilder;
import com.azure.messaging.eventhubs.LoadBalancingStrategy;
import com.azure.messaging.eventhubs.models.EventPosition;
import com.google.common.base.Strings;
import com.mulesoft.connectors.azure.eventhubs.api.TokenCredentialProperties;
import com.mulesoft.connectors.azure.eventhubs.api.connection.provider.AbstractAzureConnectionProvider;
import com.mulesoft.connectors.azure.eventhubs.api.source.checkpointing.CheckpointStoreType;
import com.mulesoft.connectors.azure.eventhubs.internal.connection.AzureEventHubsConnection;
import com.mulesoft.connectors.azure.eventhubs.internal.connection.provider.PartitionConfigurer;
import com.mulesoft.connectors.azure.eventhubs.internal.connection.provider.TokenCredentialFactory;
import com.mulesoft.connectors.azure.eventhubs.internal.error.exception.ConnectivityException;
import com.mulesoft.connectors.azure.eventhubs.internal.source.checkpointing.NullObjectCheckpointStore;
import java.time.Duration;
import java.util.Map;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="ActiveDirectoryAuthentication")
public class ActiveDirectoryConnectionProvider
extends AbstractAzureConnectionProvider<AzureEventHubsConnection> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActiveDirectoryConnectionProvider.class);
    @Parameter
    @Optional
    @ParameterDsl(allowReferences=false)
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Summary(value="To acquires a token via service principal authentication")
    protected TokenCredentialProperties tokenCredentialProperties;
    @Parameter
    @Optional(defaultValue="false")
    @ParameterDsl(allowReferences=false)
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Summary(value="Use DefaultAzureCredentials Mechanism")
    protected boolean useAzureDefaultCredential;
    @Parameter
    @Summary(value="The Event Hubs namespace name.")
    protected String namespace;
    @Parameter
    @Summary(value="Fully qualified domain name of the Event Hubs namespace")
    @Optional(defaultValue="servicebus.windows.net")
    protected String azureEndpoint;
    @Parameter
    @Optional
    @Summary(value="Specifies the Azure Active Directory host. If not valued it default to: https://login.microsoftonline.com/")
    protected String authorityHost;
    @Parameter
    @ParameterDsl(allowReferences=false)
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Optional
    @Summary(value="To select the Checkpointing Connection Provider")
    private CheckpointStoreType checkpointStoreType;

    public TokenCredentialProperties getTokenCredentialProperties() {
        return this.tokenCredentialProperties;
    }

    public void setTokenCredentialProperties(TokenCredentialProperties tokenCredentialProperties) {
        this.tokenCredentialProperties = tokenCredentialProperties;
    }

    public boolean isUseAzureDefaultCredential() {
        return this.useAzureDefaultCredential;
    }

    public void setUseAzureDefaultCredential(boolean useAzureDefaultCredential) {
        this.useAzureDefaultCredential = useAzureDefaultCredential;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getAuthorityHost() {
        return this.authorityHost;
    }

    public void setAuthorityHost(String authorityHost) {
        this.authorityHost = authorityHost;
    }

    public CheckpointStoreType getCheckpointStoreType() {
        return this.checkpointStoreType;
    }

    public void setCheckpointStoreType(CheckpointStoreType adCheckpointStoreType) {
        this.checkpointStoreType = adCheckpointStoreType;
    }

    public AzureEventHubsConnection connect() {
        AzureEventHubsConnection azureEventHubsConnection;
        try {
            azureEventHubsConnection = new AzureEventHubsConnection(this.buildProducer(), this::buildAsyncConsumer, this::buildEventProcessorClient);
        }
        catch (Exception e) {
            throw new ConnectivityException("There was a problem creating Event Hubs Connection", e);
        }
        return azureEventHubsConnection;
    }

    public ConnectionValidationResult validate(AzureEventHubsConnection connection) {
        try {
            connection.validate();
        }
        catch (Exception e) {
            return ConnectionValidationResult.failure((String)e.getMessage(), (Exception)e);
        }
        return ConnectionValidationResult.success();
    }

    public void disconnect(AzureEventHubsConnection connection) {
        connection.disconnect();
    }

    private EventHubClientBuilder buildProducer() {
        return this.buildEventHubClientBuilder();
    }

    private EventHubClientBuilder buildAsyncConsumer(String consumerGroup) {
        EventHubClientBuilder eventHubClientBuilder = this.buildEventHubClientBuilder();
        String consumerGroupToUse = this.getConsumerGroup(consumerGroup);
        eventHubClientBuilder.consumerGroup(consumerGroupToUse);
        return eventHubClientBuilder;
    }

    private EventProcessorClientBuilder buildEventProcessorClient(String consumerGroup, EventPosition eventPosition) {
        String consumerGroupToUse = this.getConsumerGroup(consumerGroup);
        EventProcessorClientBuilder eventProcessorClientBuilder = new EventProcessorClientBuilder().consumerGroup(consumerGroupToUse).loadBalancingStrategy(LoadBalancingStrategy.BALANCED).checkpointStore(this.resolveCheckpointStore()).partitionOwnershipExpirationInterval(Duration.ofMinutes(5L)).fullyQualifiedNamespace(this.getFullQualifiedNamespace()).eventHubName(this.eventHubName).credential(TokenCredentialFactory.getTokenCredential(this.tokenCredentialProperties, this.useAzureDefaultCredential, this.resolveAuthorityHost()));
        EventHubConsumerClient consumerClient = new EventHubClientBuilder().fullyQualifiedNamespace(this.getFullQualifiedNamespace()).eventHubName(this.eventHubName).credential(TokenCredentialFactory.getTokenCredential(this.tokenCredentialProperties, this.useAzureDefaultCredential, this.resolveAuthorityHost())).consumerGroup(consumerGroupToUse).buildConsumerClient();
        Map<String, EventPosition> initialPosition = new PartitionConfigurer(consumerClient, eventPosition).configure();
        consumerClient.close();
        eventProcessorClientBuilder.initialPartitionEventPosition(initialPosition);
        return eventProcessorClientBuilder;
    }

    private EventHubClientBuilder buildEventHubClientBuilder() {
        EventHubClientBuilder eventHubClientBuilder = new EventHubClientBuilder();
        eventHubClientBuilder.eventHubName(this.eventHubName).fullyQualifiedNamespace(this.getFullQualifiedNamespace()).credential(TokenCredentialFactory.getTokenCredential(this.tokenCredentialProperties, this.useAzureDefaultCredential, this.resolveAuthorityHost()));
        if (this.shareConnection) {
            eventHubClientBuilder.shareConnection();
        }
        return eventHubClientBuilder;
    }

    private String getFullQualifiedNamespace() {
        return String.format("%s." + this.azureEndpoint, this.namespace);
    }

    private String getConsumerGroup(String consumerGroup) {
        return !Strings.isNullOrEmpty((String)consumerGroup) ? consumerGroup : "$Default";
    }

    private String resolveAuthorityHost() {
        return this.authorityHost != null ? this.authorityHost : "https://login.microsoftonline.com/";
    }

    private CheckpointStore resolveCheckpointStore() {
        if (this.checkpointStoreType != null) {
            return this.checkpointStoreType.getCheckpointStore();
        }
        LOGGER.warn("\n******************************************************** \n*** An Azure Blob Storage account must be configured ***\n********************************************************");
        return new NullObjectCheckpointStore();
    }
}

