/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.azure.eventhubs.api.connection.provider;

import com.azure.messaging.eventhubs.CheckpointStore;
import com.azure.messaging.eventhubs.EventHubClientBuilder;
import com.azure.messaging.eventhubs.EventHubConsumerClient;
import com.azure.messaging.eventhubs.EventProcessorClientBuilder;
import com.azure.messaging.eventhubs.LoadBalancingStrategy;
import com.azure.messaging.eventhubs.models.EventPosition;
import com.google.common.base.Strings;
import com.mulesoft.connectors.azure.eventhubs.api.connection.provider.AbstractAzureConnectionProvider;
import com.mulesoft.connectors.azure.eventhubs.api.source.checkpointing.CheckpointStoreType;
import com.mulesoft.connectors.azure.eventhubs.internal.connection.AzureEventHubsConnection;
import com.mulesoft.connectors.azure.eventhubs.internal.connection.provider.PartitionConfigurer;
import com.mulesoft.connectors.azure.eventhubs.internal.error.exception.ConnectivityException;
import com.mulesoft.connectors.azure.eventhubs.internal.source.checkpointing.NullObjectCheckpointStore;
import java.time.Duration;
import java.util.Map;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Password;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="SASAuthentication")
public class SasConnectionProvider
extends AbstractAzureConnectionProvider<AzureEventHubsConnection> {
    private static final String CONNECTION_STRING = "Endpoint=sb://%s.servicebus.windows.net/;SharedAccessKeyName=%s;SharedAccessKey=%s";
    private static final Logger LOGGER = LoggerFactory.getLogger(SasConnectionProvider.class);
    @Parameter
    @Summary(value="The Event Hubs namespace name.")
    protected String namespace;
    @Parameter
    @Summary(value="Name of the shared access key given by Azure.")
    protected String sharedAccessKeyName;
    @Parameter
    @Summary(value="Value of the shared access key given by Azure.")
    @Password
    protected String sharedAccessKey;
    @Parameter
    @ParameterDsl(allowReferences=false)
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Optional
    @Summary(value="To select Azure Blob Storage Connection Provider")
    private CheckpointStoreType checkpointStoreType;

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getSharedAccessKeyName() {
        return this.sharedAccessKeyName;
    }

    public void setSharedAccessKeyName(String sharedAccessKeyName) {
        this.sharedAccessKeyName = sharedAccessKeyName;
    }

    public String getSharedAccessKey() {
        return this.sharedAccessKey;
    }

    public void setSharedAccessKey(String sharedAccessKey) {
        this.sharedAccessKey = sharedAccessKey;
    }

    public CheckpointStoreType getCheckpointStoreType() {
        return this.checkpointStoreType;
    }

    public void setCheckpointStoreType(CheckpointStoreType checkpointStoreType) {
        this.checkpointStoreType = checkpointStoreType;
    }

    public AzureEventHubsConnection connect() {
        AzureEventHubsConnection azureEventHubsConnection;
        try {
            azureEventHubsConnection = new AzureEventHubsConnection(this.buildProducer(), this::buildAsyncConsumer, this::buildEventProcessorClient);
        }
        catch (Exception e) {
            throw new ConnectivityException("There was a problem creating Event Hubs Connection", e);
        }
        return azureEventHubsConnection;
    }

    public ConnectionValidationResult validate(AzureEventHubsConnection connection) {
        try {
            connection.validate();
        }
        catch (Exception e) {
            return ConnectionValidationResult.failure((String)e.getMessage(), (Exception)e);
        }
        return ConnectionValidationResult.success();
    }

    public void disconnect(AzureEventHubsConnection connection) {
        connection.disconnect();
    }

    private EventHubClientBuilder buildProducer() {
        return this.buildEventHubClientBuilder();
    }

    private EventHubClientBuilder buildAsyncConsumer(String consumerGroup) {
        EventHubClientBuilder eventHubClientBuilder = this.buildEventHubClientBuilder();
        String consumerGroupToUse = this.getConsumerGroup(consumerGroup);
        eventHubClientBuilder.consumerGroup(consumerGroupToUse);
        return eventHubClientBuilder;
    }

    private EventProcessorClientBuilder buildEventProcessorClient(String consumerGroup, EventPosition eventPosition) {
        String connectionString = this.getConnectionString();
        String consumerGroupToUse = this.getConsumerGroup(consumerGroup);
        EventProcessorClientBuilder eventProcessorClientBuilder = new EventProcessorClientBuilder().connectionString(connectionString, this.eventHubName).consumerGroup(consumerGroupToUse).loadBalancingStrategy(LoadBalancingStrategy.BALANCED).checkpointStore(this.resolveCheckpointStore()).partitionOwnershipExpirationInterval(Duration.ofMinutes(5L));
        EventHubConsumerClient consumerClient = new EventHubClientBuilder().connectionString(connectionString, this.eventHubName).consumerGroup(consumerGroupToUse).buildConsumerClient();
        Map<String, EventPosition> initialPosition = new PartitionConfigurer(consumerClient, eventPosition).configure();
        consumerClient.close();
        eventProcessorClientBuilder.initialPartitionEventPosition(initialPosition);
        return eventProcessorClientBuilder;
    }

    private EventHubClientBuilder buildEventHubClientBuilder() {
        String connectionString = this.getConnectionString();
        EventHubClientBuilder eventHubClientBuilder = new EventHubClientBuilder().connectionString(connectionString, this.eventHubName);
        if (this.shareConnection) {
            eventHubClientBuilder.shareConnection();
        }
        return eventHubClientBuilder;
    }

    private String getConnectionString() {
        return String.format(CONNECTION_STRING, this.namespace, this.sharedAccessKeyName, this.sharedAccessKey);
    }

    private String getConsumerGroup(String consumerGroup) {
        return !Strings.isNullOrEmpty((String)consumerGroup) ? consumerGroup : "$Default";
    }

    private CheckpointStore resolveCheckpointStore() {
        if (this.checkpointStoreType != null) {
            return this.checkpointStoreType.getCheckpointStore();
        }
        LOGGER.warn("\n******************************************************** \n*** An Azure Blob Storage account must be configured ***\n********************************************************");
        return new NullObjectCheckpointStore();
    }
}

