/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.azure.eventhubs.api.eheventposition;

import com.azure.messaging.eventhubs.models.EventPosition;
import com.mulesoft.connectors.azure.eventhubs.api.eheventposition.EventHubEventPositionType;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.Objects;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnqueuedTimePosition
implements EventHubEventPositionType {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnqueuedTimePosition.class);
    @Parameter
    @Example(value="2023-05-18T14:11:13.550Z")
    @Summary(value="Configure to know when begin looking for an event")
    private String instant;

    @Override
    public EventPosition resolveEventPosition() {
        Instant enqueuedDateTime = Instant.now();
        try {
            enqueuedDateTime = Instant.parse(this.instant);
        }
        catch (DateTimeParseException ex) {
            LOGGER.error("Error parsing instant: {}, err: {}", (Object)this.instant, (Object)ex.getMessage());
        }
        LOGGER.info("Setting instant to: {}", (Object)enqueuedDateTime);
        return EventPosition.fromEnqueuedTime((Instant)enqueuedDateTime);
    }

    public String getInstant() {
        return this.instant;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnqueuedTimePosition that = (EnqueuedTimePosition)o;
        return Objects.equals(this.instant, that.instant);
    }

    public int hashCode() {
        return Objects.hash(this.instant);
    }
}

