/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.azure.eventhubs.api.source.checkpointing;

import com.azure.messaging.eventhubs.CheckpointStore;
import com.azure.messaging.eventhubs.checkpointstore.blob.BlobCheckpointStore;
import com.azure.storage.blob.BlobContainerAsyncClient;
import com.azure.storage.blob.BlobContainerClientBuilder;
import com.mulesoft.connectors.azure.eventhubs.api.TokenCredentialProperties;
import com.mulesoft.connectors.azure.eventhubs.api.source.checkpointing.CheckpointStoreType;
import com.mulesoft.connectors.azure.eventhubs.internal.connection.provider.TokenCredentialFactory;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

@Alias(value="Azure Blob Storage Active Directory Authentication")
public class ActiveDirectoryBlobCheckpointStoreType
implements CheckpointStoreType {
    private static final String ENDPOINT = "https://%s.blob.core.windows.net";
    @Parameter
    @Optional
    @ParameterDsl(allowReferences=false)
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    protected TokenCredentialProperties tokenCredentialProperties;
    @Parameter
    @Optional(defaultValue="false")
    @ParameterDsl(allowReferences=false)
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    protected boolean useAzureDefaultCredential;
    @Parameter
    @Summary(value="Blob Storage Container Name")
    private String containerName;
    @Parameter
    @Summary(value="Blob Storage Account Name")
    private String accountName;
    @Parameter
    @Optional
    @Summary(value="Specifies the Azure Active Directory host. If not valued it default to: https://login.microsoftonline.com/")
    protected String authorityHost;

    public TokenCredentialProperties getTokenCredentialProperties() {
        return this.tokenCredentialProperties;
    }

    public void setTokenCredentialProperties(TokenCredentialProperties tokenCredentialProperties) {
        this.tokenCredentialProperties = tokenCredentialProperties;
    }

    public boolean isUseAzureDefaultCredential() {
        return this.useAzureDefaultCredential;
    }

    public void setUseAzureDefaultCredential(boolean useAzureDefaultCredential) {
        this.useAzureDefaultCredential = useAzureDefaultCredential;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public void setContainerName(String containerName) {
        this.containerName = containerName;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getAuthorityHost() {
        return this.authorityHost;
    }

    public void setAuthorityHost(String authorityHost) {
        this.authorityHost = authorityHost;
    }

    @Override
    public CheckpointStore getCheckpointStore() {
        return new BlobCheckpointStore(this.buildAsyncClient());
    }

    private BlobContainerAsyncClient buildAsyncClient() {
        return this.buildBlobStorageAsyncClientBuilder().buildAsyncClient();
    }

    private BlobContainerClientBuilder buildBlobStorageAsyncClientBuilder() {
        return new BlobContainerClientBuilder().credential(TokenCredentialFactory.getTokenCredential(this.tokenCredentialProperties, this.useAzureDefaultCredential, this.resolveAuthorityHost())).endpoint(this.getEndpointName()).containerName(this.containerName);
    }

    private String getEndpointName() {
        return String.format(ENDPOINT, this.accountName);
    }

    private String resolveAuthorityHost() {
        return this.authorityHost != null ? this.authorityHost : "https://login.microsoftonline.com/";
    }
}

