/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.azure.eventhubs.api.source.checkpointing;

import com.azure.messaging.eventhubs.CheckpointStore;
import com.azure.messaging.eventhubs.checkpointstore.blob.BlobCheckpointStore;
import com.azure.storage.blob.BlobContainerAsyncClient;
import com.azure.storage.blob.BlobContainerClientBuilder;
import com.mulesoft.connectors.azure.eventhubs.api.source.checkpointing.CheckpointStoreType;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Password;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

@Alias(value="Azure Blob Storage SAS Authentication")
public class AzureBlobCheckpointStoreType
implements CheckpointStoreType {
    private static final String CONNECTION_STRING = "DefaultEndpointsProtocol=https;AccountName=%s;AccountKey=%s;EndpointSuffix=core.windows.net";
    @Parameter
    @Summary(value="Blob Storage Container Name")
    private String containerName;
    @Parameter
    @Summary(value="Blob Storage Account Name")
    private String accountName;
    @Parameter
    @Password
    @Summary(value="Blob Storage Account Key")
    private String accountKey;

    public String getContainerName() {
        return this.containerName;
    }

    public void setContainerName(String containerName) {
        this.containerName = containerName;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getAccountKey() {
        return this.accountKey;
    }

    public void setAccountKey(String accountKey) {
        this.accountKey = accountKey;
    }

    @Override
    public CheckpointStore getCheckpointStore() {
        return new BlobCheckpointStore(this.buildAsyncClient());
    }

    private BlobContainerAsyncClient buildAsyncClient() {
        return this.buildBlobStorageAsyncClientBuilder().buildAsyncClient();
    }

    private BlobContainerClientBuilder buildBlobStorageAsyncClientBuilder() {
        return new BlobContainerClientBuilder().connectionString(this.getConnectionString()).containerName(this.containerName);
    }

    private String getConnectionString() {
        return String.format(CONNECTION_STRING, this.accountName, this.accountKey);
    }
}

