/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.azure.eventhubs.internal.client;

import com.azure.messaging.eventhubs.EventData;
import com.azure.messaging.eventhubs.EventHubConsumerAsyncClient;
import com.azure.messaging.eventhubs.models.EventPosition;
import com.mulesoft.connectors.azure.eventhubs.internal.client.PartitionConsumerClient;
import com.mulesoft.connectors.azure.eventhubs.internal.source.eventhandler.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPartitionConsumerClient
implements PartitionConsumerClient {
    private static final Logger logger = LoggerFactory.getLogger(DefaultPartitionConsumerClient.class);
    private final EventHubConsumerAsyncClient client;

    public EventHubConsumerAsyncClient getClient() {
        return this.client;
    }

    public DefaultPartitionConsumerClient(EventHubConsumerAsyncClient client) {
        this.client = client;
    }

    @Override
    public void consume(EventHandler eventHandler, String partitionId, EventPosition eventPosition) {
        this.client.receiveFromPartition(partitionId, eventPosition).subscribe(partitionEvent -> {
            EventData event = partitionEvent.getData();
            eventHandler.handle(event);
        }, error -> logger.error("Error occurred while consuming events: {}", (Object)error.getMessage()), () -> logger.debug("Finished reading events."));
    }

    @Override
    public void close() {
        this.client.close();
    }
}

