/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.azure.eventhubs.internal.connection;

import com.azure.messaging.eventhubs.EventHubClientBuilder;
import com.azure.messaging.eventhubs.EventHubProducerClient;
import com.azure.messaging.eventhubs.EventProcessorClientBuilder;
import com.azure.messaging.eventhubs.models.EventPosition;
import com.mulesoft.connectors.azure.eventhubs.internal.client.DefaultEventHubConsumerClient;
import com.mulesoft.connectors.azure.eventhubs.internal.client.DefaultPartitionConsumerClient;
import com.mulesoft.connectors.azure.eventhubs.internal.client.DefaultPublisherClient;
import com.mulesoft.connectors.azure.eventhubs.internal.client.EventHubConsumerClient;
import com.mulesoft.connectors.azure.eventhubs.internal.client.PartitionConsumerClient;
import com.mulesoft.connectors.azure.eventhubs.internal.client.PublisherClient;
import com.mulesoft.connectors.azure.eventhubs.internal.error.exception.ConnectivityException;
import com.mulesoft.connectors.azure.eventhubs.internal.service.DefaultEventHubService;
import com.mulesoft.connectors.azure.eventhubs.internal.service.EventHubService;
import com.mulesoft.connectors.azure.eventhubs.internal.source.eventhandler.EventHandler;
import com.mulesoft.connectors.commons.template.connection.ConnectorConnection;
import java.util.function.BiFunction;
import java.util.function.Function;

public class AzureEventHubsConnection
implements ConnectorConnection {
    protected EventHubClientBuilder eventHubProducerClientBuilder;
    protected Function<String, EventHubClientBuilder> eventHubAsyncConsumerClientBuilder;
    protected BiFunction<String, EventPosition, EventProcessorClientBuilder> eventProcessorClientBuilderFunction;

    public EventHubClientBuilder getEventHubProducerClientBuilder() {
        return this.eventHubProducerClientBuilder;
    }

    public Function<String, EventHubClientBuilder> getEventHubAsyncConsumerClientBuilder() {
        return this.eventHubAsyncConsumerClientBuilder;
    }

    public BiFunction<String, EventPosition, EventProcessorClientBuilder> getEventProcessorClientBuilderFunction() {
        return this.eventProcessorClientBuilderFunction;
    }

    public AzureEventHubsConnection() {
    }

    public AzureEventHubsConnection(EventHubClientBuilder eventHubProducerClientBuilder, Function<String, EventHubClientBuilder> eventHubAsyncConsumerClientBuilder, BiFunction<String, EventPosition, EventProcessorClientBuilder> eventProcessorClientBuilderSupplier) {
        this.eventHubProducerClientBuilder = eventHubProducerClientBuilder;
        this.eventHubAsyncConsumerClientBuilder = eventHubAsyncConsumerClientBuilder;
        this.eventProcessorClientBuilderFunction = eventProcessorClientBuilderSupplier;
    }

    public PublisherClient getProducer() {
        return new DefaultPublisherClient(this.eventHubProducerClientBuilder.buildProducerClient());
    }

    public PartitionConsumerClient getPartitionConsumer(String consumerGroup) {
        return new DefaultPartitionConsumerClient(this.eventHubAsyncConsumerClientBuilder.apply(consumerGroup).buildAsyncConsumerClient());
    }

    public EventHubConsumerClient getEventHubConsumer(String consumerGroup, EventPosition eventPosition, int checkpointFrequency, EventHandler eventHandler) {
        return new DefaultEventHubConsumerClient(this.eventProcessorClientBuilderFunction.apply(consumerGroup, eventPosition), checkpointFrequency, eventHandler);
    }

    public EventHubService getEventHubService() {
        return new DefaultEventHubService(this.eventHubProducerClientBuilder.buildProducerClient());
    }

    public void disconnect() {
    }

    public void validate() {
        try (EventHubProducerClient client = this.eventHubProducerClientBuilder.buildProducerClient();){
            client.getEventHubProperties();
        }
        catch (Exception ex) {
            throw new ConnectivityException("There was a problem trying to validate the Event Hub Connection.", ex);
        }
    }
}

