/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.azure.eventhubs.internal.connection.provider;

import com.azure.core.util.IterableStream;
import com.azure.messaging.eventhubs.EventHubConsumerClient;
import com.azure.messaging.eventhubs.models.EventPosition;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionConfigurer {
    private static final Logger LOGGER = LoggerFactory.getLogger(PartitionConfigurer.class);
    EventPosition eventPosition;
    EventHubConsumerClient consumerClient;

    public PartitionConfigurer(EventHubConsumerClient consumerClient, EventPosition eventPosition) {
        this.eventPosition = eventPosition;
        this.consumerClient = consumerClient;
    }

    public Map<String, EventPosition> configure() {
        IterableStream partitionIds = this.consumerClient.getPartitionIds();
        HashMap<String, EventPosition> initialPosition = new HashMap<String, EventPosition>();
        LOGGER.debug("[configure] eventPosition: {}", (Object)this.eventPosition);
        for (String partitionId : partitionIds) {
            initialPosition.put(partitionId, this.eventPosition);
        }
        return initialPosition;
    }
}

