/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.azure.eventhubs.internal.connection.provider;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.azure.identity.DefaultAzureCredentialBuilder;
import com.mulesoft.connectors.azure.eventhubs.api.TokenCredentialProperties;
import com.mulesoft.connectors.azure.eventhubs.internal.error.exception.ConnectivityException;
import org.mule.runtime.core.api.util.StringUtils;

public class TokenCredentialFactory {
    private TokenCredentialFactory() {
    }

    public static TokenCredential getTokenCredential(TokenCredentialProperties properties, boolean useDefaultCredential, String authorityHost) {
        TokenCredentialFactory.validateTokenCredentialProperties(properties, useDefaultCredential);
        TokenCredentialFactory.validateAuthorityHost(authorityHost);
        return useDefaultCredential ? new DefaultAzureCredentialBuilder().authorityHost(authorityHost).build() : ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(properties.getClientId())).tenantId(properties.getTenantId())).clientSecret(properties.getClientSecret()).authorityHost(authorityHost)).build();
    }

    private static void validateTokenCredentialProperties(TokenCredentialProperties properties, boolean useDefaultCredential) {
        if (!useDefaultCredential && (StringUtils.isEmpty((String)properties.getClientId()) || StringUtils.isEmpty((String)properties.getClientSecret()) || StringUtils.isEmpty((String)properties.getTenantId()))) {
            throw new ConnectivityException("Client ID or Client Secret ID or Tenant ID, cannot be null or empty");
        }
    }

    private static void validateAuthorityHost(String parameter) {
        if (StringUtils.isEmpty((String)parameter)) {
            throw new ConnectivityException("Authority Host cannot be null or empty");
        }
    }
}

