/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.azure.eventhubs.internal.domain;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.mulesoft.connectors.azure.eventhubs.internal.error.exception.InvalidArgumentException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class Event {
    private final String body;
    private final String partitionId;
    private final String partitionKey;
    private final String correlationId;
    private final Map<String, Object> customMetadata;
    private final String contentType;

    private Event(String body, String partitionId, String partitionKey, String correlationId, Map<String, Object> customMetadata, String contentType) {
        if (!Strings.isNullOrEmpty((String)partitionId) && !Strings.isNullOrEmpty((String)partitionKey)) {
            throw new InvalidArgumentException("Only partition key or partition id can exist but not both at the same time");
        }
        if (Strings.isNullOrEmpty((String)body)) {
            throw new InvalidArgumentException("Body Event cannot be null or empty");
        }
        this.body = body;
        this.correlationId = correlationId;
        this.partitionId = partitionId;
        this.partitionKey = partitionKey;
        this.customMetadata = Optional.ofNullable(customMetadata).orElse(Maps.newHashMap());
        this.contentType = contentType;
    }

    public String getBody() {
        return this.body;
    }

    public String getPartitionId() {
        return this.partitionId;
    }

    public String getPartitionKey() {
        return this.partitionKey;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Map<String, Object> getCustomMetadata() {
        return this.customMetadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Event event = (Event)o;
        return Objects.equals(this.body, event.body) && Objects.equals(this.partitionId, event.partitionId) && Objects.equals(this.partitionKey, event.partitionKey) && Objects.equals(this.customMetadata, event.customMetadata);
    }

    public int hashCode() {
        return Objects.hash(this.body, this.partitionId, this.partitionKey, this.customMetadata);
    }

    public static class Builder {
        private String body;
        private String partitionId;
        private String partitionKey;
        private String correlationId;
        private String contentType;
        private Map<String, Object> customMetadata;

        private Builder() {
        }

        public static Builder getInstance() {
            return new Builder();
        }

        public Builder body(String body) {
            this.body = body;
            return this;
        }

        public Builder correlationId(String correlationId) {
            this.correlationId = correlationId;
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder partitionId(String partitionId) {
            this.partitionId = partitionId;
            return this;
        }

        public Builder partitionKey(String partitionKey) {
            this.partitionKey = partitionKey;
            return this;
        }

        public Builder customMetadata(Map<String, Object> customMetadata) {
            this.customMetadata = customMetadata;
            return this;
        }

        public Event build() {
            return new Event(this.body, this.partitionId, this.partitionKey, this.correlationId, this.customMetadata, this.contentType);
        }
    }
}

