/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.azure.eventhubs.internal.error;

import com.azure.core.amqp.exception.AmqpErrorCondition;
import com.azure.core.amqp.exception.AmqpException;
import com.mulesoft.connectors.azure.eventhubs.internal.error.exception.AuthenticationException;
import com.mulesoft.connectors.azure.eventhubs.internal.error.exception.ConnectivityException;
import com.mulesoft.connectors.azure.eventhubs.internal.error.exception.InvalidArgumentException;

public class AmqpErrorTranslator {
    private AmqpErrorTranslator() {
    }

    public static void tryToHandleKnownAmqpException(AmqpException ex) {
        if (AmqpErrorCondition.ARGUMENT_OUT_OF_RANGE_ERROR.equals((Object)ex.getErrorCondition())) {
            throw new InvalidArgumentException(ex.getMessage());
        }
        if (AmqpErrorCondition.UNAUTHORIZED_ACCESS.equals((Object)ex.getErrorCondition())) {
            throw new AuthenticationException(ex.getMessage());
        }
        if (AmqpErrorCondition.PROTON_IO.equals((Object)ex.getErrorCondition())) {
            throw new ConnectivityException(ex.getMessage());
        }
    }
}

