/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.azure.eventhubs.internal.operation;

import com.mulesoft.connectors.azure.eventhubs.api.Event;
import com.mulesoft.connectors.azure.eventhubs.api.PartitionInfo;
import com.mulesoft.connectors.azure.eventhubs.internal.client.PublisherClient;
import com.mulesoft.connectors.azure.eventhubs.internal.connection.AzureEventHubsConnection;
import com.mulesoft.connectors.azure.eventhubs.internal.error.provider.AzureEventHubErrorProvider;
import com.mulesoft.connectors.azure.eventhubs.internal.operation.mapper.EventMapper;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;

public class PublishOperation {
    @DisplayName(value="Send a single event")
    @MediaType(value="*/*", strict=false)
    @Throws(value={AzureEventHubErrorProvider.class})
    public void publish(@Connection AzureEventHubsConnection connection, @Content Event event, @Optional String correlationId, @Optional String contentType, @ParameterGroup(name="Partition Info") PartitionInfo partitionParameters) throws IOException {
        com.mulesoft.connectors.azure.eventhubs.internal.domain.Event eventToPublish = EventMapper.fromEventAndPartitionInfoAndCorrelationId(event, partitionParameters, correlationId, contentType);
        try (PublisherClient client = connection.getProducer();){
            client.publish(eventToPublish);
        }
    }

    @DisplayName(value="Bulk Publish")
    @MediaType(value="*/*", strict=false)
    @Throws(value={AzureEventHubErrorProvider.class})
    public void bulkPublish(@Connection AzureEventHubsConnection connection, @Content List<Event> events, @ParameterGroup(name="Partition Info") PartitionInfo partitionParameters, @Optional String correlationId, @Optional String contentType, @Optional(defaultValue="0") int maxBatchSizeInBytes) throws IOException {
        List<com.mulesoft.connectors.azure.eventhubs.internal.domain.Event> eventsToPublish = events.stream().map(event -> EventMapper.fromEventAndPartitionInfoAndCorrelationId(event, partitionParameters, correlationId, contentType)).collect(Collectors.toList());
        try (PublisherClient client = connection.getProducer();){
            client.bulkPublish(eventsToPublish, partitionParameters.getPartitionId(), partitionParameters.getPartitionKey(), maxBatchSizeInBytes);
        }
    }
}

