/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.azure.eventhubs.internal.source;

import com.azure.messaging.eventhubs.models.EventPosition;
import com.mulesoft.connectors.azure.eventhubs.api.EventAttributes;
import com.mulesoft.connectors.azure.eventhubs.api.eventposition.EventPositionType;
import com.mulesoft.connectors.azure.eventhubs.internal.client.PartitionConsumerClient;
import com.mulesoft.connectors.azure.eventhubs.internal.connection.AzureEventHubsConnection;
import com.mulesoft.connectors.azure.eventhubs.internal.connection.provider.PartitionIdValueProvider;
import com.mulesoft.connectors.azure.eventhubs.internal.source.eventhandler.DefaultEventHandler;
import java.io.InputStream;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.annotation.source.BackPressure;
import org.mule.runtime.extension.api.annotation.source.ClusterSupport;
import org.mule.runtime.extension.api.annotation.source.SourceClusterSupport;
import org.mule.runtime.extension.api.annotation.values.OfValues;
import org.mule.runtime.extension.api.runtime.source.BackPressureMode;
import org.mule.runtime.extension.api.runtime.source.Source;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;

@MediaType(value="*/*", strict=false)
@ClusterSupport(value=SourceClusterSupport.DEFAULT_PRIMARY_NODE_ONLY)
@BackPressure(defaultMode=BackPressureMode.DROP, supportedModes={BackPressureMode.DROP, BackPressureMode.WAIT})
public class PartitionListener
extends Source<InputStream, EventAttributes> {
    @Parameter
    @OfValues(value=PartitionIdValueProvider.class)
    private String partitionId;
    @Parameter
    @Optional
    @Summary(value="The Consumer Group you want to belong to.")
    private String consumerGroup;
    @Connection
    private ConnectionProvider<AzureEventHubsConnection> connectionProvider;
    @Optional
    @Parameter
    @ParameterDsl(allowReferences=false)
    private EventPositionType eventPositionType;
    private AzureEventHubsConnection eventHubsConnection;
    private PartitionConsumerClient consumer;

    public String getPartitionId() {
        return this.partitionId;
    }

    public void setPartitionId(String partitionId) {
        this.partitionId = partitionId;
    }

    public String getConsumerGroup() {
        return this.consumerGroup;
    }

    public void setConsumerGroup(String consumerGroup) {
        this.consumerGroup = consumerGroup;
    }

    public ConnectionProvider<AzureEventHubsConnection> getConnectionProvider() {
        return this.connectionProvider;
    }

    public void setConnectionProvider(ConnectionProvider<AzureEventHubsConnection> connectionProvider) {
        this.connectionProvider = connectionProvider;
    }

    public EventPositionType getEventPositionType() {
        return this.eventPositionType;
    }

    public void setEventPositionType(EventPositionType eventPositionType) {
        this.eventPositionType = eventPositionType;
    }

    public AzureEventHubsConnection getEventHubsConnection() {
        return this.eventHubsConnection;
    }

    public void setEventHubsConnection(AzureEventHubsConnection eventHubsConnection) {
        this.eventHubsConnection = eventHubsConnection;
    }

    public PartitionConsumerClient getConsumer() {
        return this.consumer;
    }

    public void setConsumer(PartitionConsumerClient consumer) {
        this.consumer = consumer;
    }

    public void onStart(SourceCallback<InputStream, EventAttributes> sourceCallback) throws ConnectionException {
        this.eventHubsConnection = (AzureEventHubsConnection)this.connectionProvider.connect();
        EventPosition eventPosition = this.eventPositionType != null ? this.eventPositionType.resolveEventPosition() : EventPosition.latest();
        this.consumer = this.eventHubsConnection.getPartitionConsumer(this.consumerGroup);
        DefaultEventHandler eventHandler = new DefaultEventHandler(sourceCallback);
        this.consumer.consume(eventHandler, this.partitionId, eventPosition);
    }

    public void onStop() {
        if (this.eventHubsConnection != null) {
            this.connectionProvider.disconnect((Object)this.eventHubsConnection);
        }
        if (this.consumer != null) {
            this.consumer.close();
        }
    }
}

