/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.azure.eventhubs.internal.source.checkpointing;

import com.azure.core.util.CoreUtils;
import com.azure.messaging.eventhubs.CheckpointStore;
import com.azure.messaging.eventhubs.models.Checkpoint;
import com.azure.messaging.eventhubs.models.PartitionOwnership;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class NullObjectCheckpointStore
implements CheckpointStore {
    private static final String OWNERSHIP = "ownership";
    private static final String SEPARATOR = "/";
    private static final String CHECKPOINT = "checkpoint";
    private final Map<String, PartitionOwnership> partitionOwnershipMap = new ConcurrentHashMap<String, PartitionOwnership>();
    private final Map<String, Checkpoint> checkpointsMap = new ConcurrentHashMap<String, Checkpoint>();

    public Map<String, PartitionOwnership> getPartitionOwnershipMap() {
        return this.partitionOwnershipMap;
    }

    public Map<String, Checkpoint> getCheckpointsMap() {
        return this.checkpointsMap;
    }

    public Flux<PartitionOwnership> listOwnership(String fullyQualifiedNamespace, String eventHubName, String consumerGroup) {
        String prefix = this.prefixBuilder(fullyQualifiedNamespace, eventHubName, consumerGroup, OWNERSHIP);
        return Flux.fromIterable(this.partitionOwnershipMap.keySet()).filter(key -> key.startsWith(prefix)).map(key -> this.partitionOwnershipMap.get(key));
    }

    private String prefixBuilder(String fullyQualifiedNamespace, String eventHubName, String consumerGroup, String type) {
        return (fullyQualifiedNamespace + SEPARATOR + eventHubName + SEPARATOR + consumerGroup + SEPARATOR + type).toLowerCase(Locale.ROOT);
    }

    public Flux<PartitionOwnership> claimOwnership(List<PartitionOwnership> requestedPartitionOwnerships) {
        if (CoreUtils.isNullOrEmpty(requestedPartitionOwnerships)) {
            return Flux.empty();
        }
        PartitionOwnership firstEntry = requestedPartitionOwnerships.get(0);
        String prefix = this.prefixBuilder(firstEntry.getFullyQualifiedNamespace(), firstEntry.getEventHubName(), firstEntry.getConsumerGroup(), OWNERSHIP);
        return Flux.fromIterable(requestedPartitionOwnerships).filter(ownershipRequest -> {
            PartitionOwnership existing = this.partitionOwnershipMap.get(ownershipRequest.getPartitionId());
            if (existing == null) {
                return true;
            }
            return existing.getETag().equals(ownershipRequest.getETag());
        }).map(partitionOwnership -> {
            partitionOwnership.setETag(UUID.randomUUID().toString()).setLastModifiedTime(Long.valueOf(System.currentTimeMillis()));
            this.partitionOwnershipMap.put(prefix + SEPARATOR + partitionOwnership.getPartitionId(), (PartitionOwnership)partitionOwnership);
            return partitionOwnership;
        });
    }

    public Flux<Checkpoint> listCheckpoints(String fullyQualifiedNamespace, String eventHubName, String consumerGroup) {
        String prefix = this.prefixBuilder(fullyQualifiedNamespace, eventHubName, consumerGroup, CHECKPOINT);
        return Flux.fromIterable(this.checkpointsMap.keySet()).filter(key -> key.startsWith(prefix)).map(key -> this.checkpointsMap.get(key));
    }

    public Mono<Void> updateCheckpoint(Checkpoint checkpoint) {
        if (checkpoint == null) {
            return Mono.error((Throwable)new NullPointerException("checkpoint cannot be null"));
        }
        String prefix = this.prefixBuilder(checkpoint.getFullyQualifiedNamespace(), checkpoint.getEventHubName(), checkpoint.getConsumerGroup(), CHECKPOINT);
        this.checkpointsMap.put(prefix + SEPARATOR + checkpoint.getPartitionId(), checkpoint);
        return Mono.empty();
    }
}

