/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.azure.eventhubs.internal.source.eventhandler;

import com.azure.messaging.eventhubs.EventData;
import com.mulesoft.connectors.azure.eventhubs.api.EventAttributes;
import com.mulesoft.connectors.azure.eventhubs.internal.source.eventhandler.EventHandler;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;

public class DefaultEventHandler
implements EventHandler {
    private SourceCallback<InputStream, EventAttributes> sourceCallback;

    public DefaultEventHandler() {
    }

    public DefaultEventHandler(SourceCallback<InputStream, EventAttributes> sourceCallback) {
        this.sourceCallback = sourceCallback;
    }

    public SourceCallback<InputStream, EventAttributes> getSourceCallback() {
        return this.sourceCallback;
    }

    @Override
    public void handle(EventData event) {
        String content = new String(event.getBody(), StandardCharsets.UTF_8);
        this.sourceCallback.handle(Result.builder().mediaType(this.solveMediaType(event.getContentType())).output((Object)new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8))).attributes((Object)this.buildEventAttributes(event)).build());
    }

    private EventAttributes buildEventAttributes(EventData eventData) {
        return EventAttributes.Builder.newInstance().contentType(this.solveMediaType(eventData.getContentType()).toString()).correlationId(eventData.getCorrelationId()).enqueuedTime(eventData.getEnqueuedTime()).messageId(eventData.getMessageId()).offset(eventData.getOffset()).sequenceNumber(eventData.getSequenceNumber()).metadata(eventData.getProperties()).correlationId(eventData.getCorrelationId()).build();
    }

    private MediaType solveMediaType(String contentType) {
        MediaType mediaType;
        try {
            mediaType = MediaType.parse((String)contentType);
        }
        catch (Exception ex) {
            mediaType = MediaType.BINARY;
        }
        return mediaType;
    }
}

