/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.b2b.sync.provider;

import com.mulesoft.b2b.sync.ObjectStoreCloudhubManagement;
import com.mulesoft.b2b.sync.config.SyncConfigurationProvided;
import com.mulesoft.b2b.sync.provider.AbstractObjectStoreWithlockManagerProvider;
import com.mulesoft.b2b.sync.provider.ObjectStoreUsingLockFactory;
import com.mulesoft.b2b.sync.provider.ObjectStoreWithLockManager;

public class LockWithObjectStoreForCloudHub
extends AbstractObjectStoreWithlockManagerProvider {
    private final boolean cloudhubEnvironment;
    private final ObjectStoreUsingLockFactory objectStoreUsingLockFactory;

    public LockWithObjectStoreForCloudHub(SyncConfigurationProvided config) {
        super(config);
        String workerIp = System.getProperty("worker.publicIP");
        String forceUsingLockFactory = System.getProperty("forceUsingLockFactory");
        boolean inCloudhub = workerIp != null && workerIp.length() > 0;
        boolean forceLockFactory = "true".equalsIgnoreCase(forceUsingLockFactory);
        this.cloudhubEnvironment = inCloudhub && !forceLockFactory;
        this.objectStoreUsingLockFactory = new ObjectStoreUsingLockFactory(this.getConfig());
    }

    @Override
    protected ObjectStoreWithLockManager createObjectStoreWithLockManager() {
        return this.cloudhubEnvironment ? new ObjectStoreCloudhubManagement(this.getConfig()) : this.objectStoreUsingLockFactory.createObjectStoreWithLockManager();
    }
}

