/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.b2b.sync.provider;

import com.mulesoft.b2b.sync.config.SyncConfigurationProvided;
import com.mulesoft.b2b.sync.provider.ObjectStoreWithLockManager;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractObjectStoreWithlockManagerProvider {
    private static Map<String, ObjectStoreWithLockManager> objectStoreManagementMap;
    private SyncConfigurationProvided config;
    private static final Logger logger;

    public AbstractObjectStoreWithlockManagerProvider(SyncConfigurationProvided config) {
        this.config = config;
    }

    public static void initKeyManagementMap() {
        objectStoreManagementMap = new HashMap<String, ObjectStoreWithLockManager>();
    }

    private static synchronized ObjectStoreWithLockManager getOrCreateFor(AbstractObjectStoreWithlockManagerProvider provider) {
        String idToUse = provider.config.getIdToUse();
        if (objectStoreManagementMap == null) {
            AbstractObjectStoreWithlockManagerProvider.initKeyManagementMap();
        }
        if (objectStoreManagementMap.containsKey(idToUse)) {
            return objectStoreManagementMap.get(idToUse);
        }
        ObjectStoreWithLockManager km = provider.createObjectStoreWithLockManager();
        logger.info("A new ObjectStoreManager for object " + km.getInfo() + " was created");
        objectStoreManagementMap.put(idToUse, km);
        return km;
    }

    protected abstract ObjectStoreWithLockManager createObjectStoreWithLockManager();

    public ObjectStoreWithLockManager getKeyManagement() {
        return AbstractObjectStoreWithlockManagerProvider.getOrCreateFor(this);
    }

    protected SyncConfigurationProvided getConfig() {
        return this.config;
    }

    static {
        logger = LoggerFactory.getLogger(AbstractObjectStoreWithlockManagerProvider.class);
    }
}

