/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.b2b.sync.key;

import com.mulesoft.b2b.sync.ObjectStoreSyncKeyManagement;
import com.mulesoft.b2b.sync.key.KeyManagerCoordinator;
import com.mulesoft.b2b.sync.key.KeyOperationResult;
import com.mulesoft.b2b.sync.key.LocalObjectStore;
import com.mulesoft.b2b.sync.operation.ObjectStoreOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.mule.runtime.api.scheduler.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectStoreKeyManagerWithLock {
    private static final Logger logger = LoggerFactory.getLogger(ObjectStoreKeyManagerWithLock.class);
    private final ObjectStoreSyncKeyManagement objectStoreSyncKeyManagement;
    private final String key;
    private final Scheduler scheduler;
    private Collection<KeyOperationResult> nextJobs;
    private Future futureWork;

    public ObjectStoreKeyManagerWithLock(ObjectStoreSyncKeyManagement objectStoreSyncKeyManagement, Scheduler scheduler, String key) {
        this.objectStoreSyncKeyManagement = objectStoreSyncKeyManagement;
        this.key = key;
        this.nextJobs = new ArrayList<KeyOperationResult>();
        this.scheduler = scheduler;
        objectStoreSyncKeyManagement.checkLockFor(this.getKey());
    }

    public <T extends Serializable> T accept(ObjectStoreOperation<T> operation) {
        logger.debug(this.getKeyLockInfo() + ": New job accepted");
        KeyOperationResult result = new KeyOperationResult(operation);
        this.newJob(result);
        return (T)this.waitForComplete(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends Serializable> T waitForComplete(KeyOperationResult<T> result) {
        logger.debug(this.getKeyLockInfo() + ": Wait for obtain result!");
        while (!result.isExecuted()) {
            this.notifyCoordinator();
            try {
                KeyOperationResult<T> keyOperationResult = result;
                synchronized (keyOperationResult) {
                    result.wait(3000L);
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        logger.debug(this.getKeyLockInfo() + ": Ready to get result!");
        return (T)((Serializable)result.getResult());
    }

    private synchronized void notifyCoordinator() {
        boolean createWork = false;
        if (this.futureWork == null) {
            logger.debug(this.getKeyLockInfo() + ": Creating future coordinator for processing");
            createWork = true;
        } else if (this.futureWork.isDone()) {
            logger.debug(this.getKeyLockInfo() + ": Coordinator work done. New should be created");
            createWork = true;
        }
        if (createWork) {
            KeyManagerCoordinator coordinator = new KeyManagerCoordinator(this);
            this.futureWork = this.scheduler.submit((Callable)coordinator);
            logger.debug(this.getKeyLockInfo() + ": Submitting future work " + this.futureWork.hashCode());
        }
    }

    public String getKey() {
        return this.key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newJob(KeyOperationResult result) {
        Collection<KeyOperationResult> collection = this.nextJobs;
        synchronized (collection) {
            this.nextJobs.add(result);
            logger.debug(this.getKeyLockInfo() + ": New job added to next jobs. Pending jobs " + this.nextJobs.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processWithLock() {
        logger.debug(this.getKeyLockInfo() + ": Waiting for lock");
        try {
            this.objectStoreSyncKeyManagement.getLockFor(this);
        }
        catch (Throwable t) {
            this.errorGettingLock(t);
            return;
        }
        logger.debug(this.getKeyLockInfo() + ": Lock obtaining. Process all queued jobs");
        ArrayList<KeyOperationResult> resultsToProcess = new ArrayList<KeyOperationResult>();
        try {
            this.getJobsToProcessInto(resultsToProcess);
            logger.debug(this.getKeyLockInfo() + ": Jobs to process " + resultsToProcess.size());
            LocalObjectStore localObjectStore = this.getObjectStoreFor(resultsToProcess);
            if (localObjectStore != null) {
                for (KeyOperationResult result : resultsToProcess) {
                    result.execute(localObjectStore);
                }
                this.saveLastValue(localObjectStore, resultsToProcess);
            }
        }
        finally {
            logger.debug(this.getKeyLockInfo() + ": Releasing lock");
            this.objectStoreSyncKeyManagement.releaseLockFor(this);
        }
        logger.debug(this.getKeyLockInfo() + ": Notifying process");
        Iterator iterator = resultsToProcess.iterator();
        while (iterator.hasNext()) {
            KeyOperationResult result;
            KeyOperationResult keyOperationResult = result = (KeyOperationResult)iterator.next();
            synchronized (keyOperationResult) {
                result.notify();
            }
        }
        logger.debug(this.getKeyLockInfo() + ": End coordinator");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getJobsToProcessInto(Collection<KeyOperationResult> collection) {
        Collection<KeyOperationResult> collection2 = this.nextJobs;
        synchronized (collection2) {
            collection.addAll(this.nextJobs);
            this.nextJobs.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void errorGettingLock(Throwable exception) {
        try {
            logger.error(this.getKeyLockInfo() + ": Error getting lock. Notify.", exception);
            ArrayList<KeyOperationResult> resultsToDiscard = new ArrayList<KeyOperationResult>();
            logger.warn(this.getKeyLockInfo() + ": Notifying pending jobs. Jobs to notify: " + this.nextJobs.size());
            this.getJobsToProcessInto(resultsToDiscard);
            logger.warn(this.getKeyLockInfo() + ": Jobs to discard " + resultsToDiscard.size());
            for (KeyOperationResult toDiscard : resultsToDiscard) {
                toDiscard.notifyException(exception);
                KeyOperationResult keyOperationResult = toDiscard;
                synchronized (keyOperationResult) {
                    toDiscard.notify();
                }
            }
            logger.debug(this.getKeyLockInfo() + ": Ending work with error");
        }
        catch (Throwable t) {
            logger.error("Error notifying jobs", t);
        }
    }

    private void saveLastValue(LocalObjectStore localObjectStore, Collection<KeyOperationResult> resultsToProcess) {
        this.saveLastValue(localObjectStore, resultsToProcess, true);
    }

    private void saveLastValue(LocalObjectStore localObjectStore, Collection<KeyOperationResult> resultsToProcess, boolean retry) {
        try {
            this.objectStoreSyncKeyManagement.setObjectStoreValueFor(this, localObjectStore.getValue());
        }
        catch (Throwable t) {
            logger.warn(this.getKeyLockInfo() + ": Error saving object store", t);
            if (retry) {
                this.saveLastValue(localObjectStore, resultsToProcess, false);
            }
            for (KeyOperationResult r : resultsToProcess) {
                r.notifyException(t);
            }
        }
    }

    private LocalObjectStore getObjectStoreFor(Collection<KeyOperationResult> resultsToProcess) {
        try {
            return this.objectStoreSyncKeyManagement.createLocalObjectStoreFor(resultsToProcess, this.getKey(), this);
        }
        catch (Throwable t) {
            for (KeyOperationResult r : resultsToProcess) {
                r.notifyException(t);
            }
            return null;
        }
    }

    public String getKeyLockInfo() {
        return this.key + "-LOCK ";
    }
}

