/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.b2b.sync.operation;

import com.mulesoft.b2b.sync.operation.IncrementStringOp;
import com.mulesoft.b2b.sync.operation.ObjectStoreOperation;
import java.io.Serializable;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreException;

public class GetStringFromObjectStore
implements ObjectStoreOperation<String> {
    private final String key;
    private final String initial;
    private final IncrementStringOp incrementStringOp;

    public GetStringFromObjectStore(String key, String initial, IncrementStringOp incrementStringOp) {
        this.key = key;
        this.initial = initial;
        this.incrementStringOp = incrementStringOp;
    }

    @Override
    public String apply(ObjectStore counterObjectStore) throws ObjectStoreException {
        String count;
        if (counterObjectStore.contains(this.key)) {
            count = this.getStringValue(counterObjectStore.retrieve(this.key));
            if (count == null) {
                throw new RuntimeException("String value expected for key: " + this.key);
            }
            count = this.incrementStringOp.increment(count);
            counterObjectStore.remove(this.key);
        } else {
            count = this.initial;
        }
        counterObjectStore.store(this.key, (Serializable)((Object)count));
        return count;
    }

    private String getStringValue(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof TypedValue) {
            Object typedValue = ((TypedValue)value).getValue();
            if (typedValue instanceof String) {
                return (String)typedValue;
            }
            if (typedValue instanceof Integer) {
                return String.valueOf(typedValue);
            }
        }
        return null;
    }
}

