/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.b2b.sync;

import com.mulesoft.b2b.sync.config.SyncConfigurationProvided;
import com.mulesoft.b2b.sync.key.KeyOperationResult;
import com.mulesoft.b2b.sync.key.LocalObjectStore;
import com.mulesoft.b2b.sync.key.ObjectStoreKeyManagerWithLock;
import com.mulesoft.b2b.sync.operation.ObjectStoreOperation;
import com.mulesoft.b2b.sync.provider.ObjectStoreWithLockManager;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections4.map.LRUMap;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ObjectStoreSyncKeyManagement
implements ObjectStoreWithLockManager {
    private static final Logger logger = LoggerFactory.getLogger(ObjectStoreSyncKeyManagement.class);
    private final SyncConfigurationProvided config;
    private final String id;
    private final Map<String, ObjectStoreKeyManagerWithLock> cache;

    protected ObjectStoreSyncKeyManagement(SyncConfigurationProvided config) {
        this.config = config;
        this.id = config.getIdToUse() + "[" + this.hashCode() + "]";
        this.cache = new LRUMap(200, 10);
    }

    protected ObjectStore getCounterObjectStore() {
        return this.config.getObjectStore();
    }

    @Override
    public <T extends Serializable> T executeWithoutLock(ObjectStoreOperation<T> operation) {
        try {
            return (T)((Serializable)operation.apply(this.config.getObjectStore()));
        }
        catch (ObjectStoreException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void registerForSync(String key) {
    }

    @Override
    public <T extends Serializable> T executeWithLock(String key, ObjectStoreOperation<T> operation) {
        ObjectStoreKeyManagerWithLock keyManager = this.getKeyManagerFor(key);
        if (keyManager == null) {
            throw new RuntimeException("There is no manager registered for key: " + key);
        }
        return keyManager.accept(operation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectStoreKeyManagerWithLock getKeyManagerFor(String key) {
        ObjectStoreSyncKeyManagement objectStoreSyncKeyManagement = this;
        synchronized (objectStoreSyncKeyManagement) {
            ObjectStoreKeyManagerWithLock keyManager = this.cache.get(key);
            if (keyManager == null) {
                logger.debug("Adding key manager to cache for key: " + key + "-LOCK");
                keyManager = new ObjectStoreKeyManagerWithLock(this, this.config.getScheduler(), key);
                this.cache.put(key, keyManager);
            } else {
                logger.debug("Key manager got from cache for key: " + key + "-LOCK");
            }
            return keyManager;
        }
    }

    public void getLockFor(ObjectStoreKeyManagerWithLock keyManager) {
        logger.debug(keyManager.getKeyLockInfo() + ": Try to get lock for " + keyManager.getKey());
        this.getLockFor(keyManager.getKey());
        logger.debug(keyManager.getKeyLockInfo() + ": Lock obtained for " + keyManager.getKey());
    }

    public void releaseLockFor(ObjectStoreKeyManagerWithLock keyManager) {
        logger.debug(keyManager.getKeyLockInfo() + ": Task finished. Releasing lock for " + keyManager.getKey());
        this.releaseLockFor(keyManager.getKey());
        logger.debug(keyManager.getKeyLockInfo() + ": Lock released for " + keyManager.getKey());
    }

    public Serializable getObjectStoreValueFor(ObjectStoreKeyManagerWithLock keyManager) throws ObjectStoreException {
        if (this.config.getObjectStore().contains(keyManager.getKey())) {
            return this.config.getObjectStore().retrieve(keyManager.getKey());
        }
        return null;
    }

    public void setObjectStoreValueFor(ObjectStoreKeyManagerWithLock keyManager, Serializable value) throws ObjectStoreException {
        if (this.config.getObjectStore().contains(keyManager.getKey())) {
            this.config.getObjectStore().remove(keyManager.getKey());
        }
        if (value != null) {
            this.config.getObjectStore().store(keyManager.getKey(), value);
        }
    }

    protected abstract void getLockFor(String var1);

    protected abstract void releaseLockFor(String var1);

    @Override
    public String getInfo() {
        return this.id;
    }

    public LocalObjectStore createLocalObjectStoreFor(Collection<KeyOperationResult> resultsToProcess, String key, ObjectStoreKeyManagerWithLock keyManager) throws ObjectStoreException {
        return new LocalObjectStore(this.config.getObjectStore(), this.getObjectStoreValueFor(keyManager), key);
    }

    public void checkLockFor(String key) {
    }

    protected LockFactory getLockFactory() {
        return this.config.getLockFactory();
    }
}

