/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.b2b.sync.provider;

import com.mulesoft.b2b.sync.ObjectStoreCloudhubManagement;
import com.mulesoft.b2b.sync.config.SyncConfigurationProvided;
import com.mulesoft.b2b.sync.config.SyncMode;
import com.mulesoft.b2b.sync.provider.AbstractObjectStoreWithlockManagerProvider;
import com.mulesoft.b2b.sync.provider.ObjectStoreUsingLockFactory;
import com.mulesoft.b2b.sync.provider.ObjectStoreWithLockManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockWithObjectStoreForCloudHub
extends AbstractObjectStoreWithlockManagerProvider {
    private static final Logger logger = LoggerFactory.getLogger(LockWithObjectStoreForCloudHub.class);
    private final boolean cloudhubEnvironment;
    private final ObjectStoreUsingLockFactory objectStoreUsingLockFactory;

    public LockWithObjectStoreForCloudHub(SyncConfigurationProvided config) {
        super(config);
        this.cloudhubEnvironment = config.getMode().equals((Object)SyncMode.USING_ClOUDHUB);
        if (this.cloudhubEnvironment) {
            logger.info("Sync manager for " + config.getIdToUse() + " - It will be managed using ObjectStore for locking");
        } else {
            logger.info("Sync manager for " + config.getIdToUse() + " - It will be managed using the Runtime LockManager for locking");
        }
        this.objectStoreUsingLockFactory = new ObjectStoreUsingLockFactory(this.getConfig());
    }

    @Override
    protected ObjectStoreWithLockManager createObjectStoreWithLockManager() {
        return this.cloudhubEnvironment ? new ObjectStoreCloudhubManagement(this.getConfig()) : this.objectStoreUsingLockFactory.createObjectStoreWithLockManager();
    }
}

