/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.edifactpre.extension.api.config;

import com.mulesoft.flatfile.lexical.EdiConstants;
import com.mulesoft.flatfile.lexical.edifact.EdifactConstants;
import java.nio.charset.Charset;

public enum CharacterEncoding {
    PLATFORM("PLATFORM", EdifactConstants.LEVELY),
    ASCII_A("ASCII Level A", EdifactConstants.LEVELA),
    ASCII_B("ASCII Level B", EdifactConstants.LEVELB),
    ISO8859_1("ISO-8859-1", EdifactConstants.LEVELC),
    ISO8859_2("ISO-8859-2", (EdifactConstants.SyntaxIdentifier)EdifactConstants.EDIFACT_CHARSETS.get("UNOD")),
    ISO8859_3("ISO-8859-3", (EdifactConstants.SyntaxIdentifier)EdifactConstants.EDIFACT_CHARSETS.get("UNOG")),
    ISO8859_4("ISO-8859-4", (EdifactConstants.SyntaxIdentifier)EdifactConstants.EDIFACT_CHARSETS.get("UNOH")),
    ISO8859_5("ISO-8859-5", (EdifactConstants.SyntaxIdentifier)EdifactConstants.EDIFACT_CHARSETS.get("UNOE")),
    ISO8859_6("ISO-8859-6", (EdifactConstants.SyntaxIdentifier)EdifactConstants.EDIFACT_CHARSETS.get("UNOI")),
    ISO8859_7("ISO-8859-7", (EdifactConstants.SyntaxIdentifier)EdifactConstants.EDIFACT_CHARSETS.get("UNOF")),
    ISO8859_8("ISO-8859-8", (EdifactConstants.SyntaxIdentifier)EdifactConstants.EDIFACT_CHARSETS.get("UNOJ")),
    ISO8859_9("ISO-8859-9", (EdifactConstants.SyntaxIdentifier)EdifactConstants.EDIFACT_CHARSETS.get("UNOK")),
    UTF8("UTF-8", EdifactConstants.LEVELY);

    public final Charset characterSet;
    public final EdifactConstants.SyntaxIdentifier syntaxIdentifier;

    private CharacterEncoding(String name, EdifactConstants.SyntaxIdentifier syntax) {
        if (name.startsWith("PLATFORM")) {
            this.characterSet = EdiConstants.UTF8_CHARSET;
        } else if (name.startsWith("ASCII")) {
            this.characterSet = EdiConstants.ASCII_CHARSET;
        } else {
            Charset chset = null;
            try {
                chset = Charset.forName(name);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            this.characterSet = chset;
        }
        this.syntaxIdentifier = syntax;
    }
}

