/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.flatfile.lexical.edifact.error;

import com.mulesoft.flatfile.lexical.edifact.EdifactConstants;
import com.mulesoft.flatfile.lexical.edifact.error.descriptor.ErrorDescriptor;
import com.mulesoft.flatfile.lexical.edifact.error.descriptor.InGroupErrorDescriptor;
import com.mulesoft.flatfile.lexical.edifact.error.descriptor.InInterchangeErrorDescriptor;
import com.mulesoft.flatfile.lexical.edifact.error.descriptor.InMessageErrorDescriptor;
import com.mulesoft.flatfile.lexical.edifact.error.descriptor.InRootErrorDescriptor;
import com.mulesoft.flatfile.schema.edifact.EdifactAcknowledgment;
import com.mulesoft.flatfile.schema.edifact.EdifactInterchangeParser;
import com.mulesoft.flatfile.schema.edifact.EdifactParserConfig;
import java.util.logging.Logger;

public abstract class BaseError {
    protected int segmentNumber;
    protected String segmentTag;
    protected boolean isFatal;
    protected EdifactConstants.ErrorType errorType;
    protected String errorCode;
    protected String errorText;
    protected EdifactConstants.ErrorLevel errorLevel;
    protected int interSegmNumber;
    protected String messageId;
    protected String errorDetail;
    private ErrorDescriptor descriptor;
    protected static final Logger logger = Logger.getLogger(BaseError.class.getName());

    public BaseError(EdifactConstants.ErrorType errorType, EdifactConstants.ErrorLevel errorLevel, EdifactAcknowledgment.SyntaxError error, EdifactInterchangeParser parser) {
        this.segmentNumber = this.getErrorSegmentNumber(parser);
        this.segmentTag = parser.segmentTag();
        this.isFatal = this.checkFatal(error, parser.config());
        this.errorType = errorType;
        this.errorCode = error.code();
        this.errorText = error.text();
        this.errorLevel = errorLevel;
        this.interSegmNumber = parser.interchangeSegmentNumber();
        this.messageId = parser.messageReference();
        this.errorDetail = this.descriptor.buildDetail(this.isFatal, this.errorText);
    }

    private int getErrorSegmentNumber(EdifactInterchangeParser parser) {
        int currentIndex = parser.segmentNumber();
        if (parser.inMessage()) {
            this.descriptor = new InMessageErrorDescriptor(parser);
            return currentIndex - parser.messageStartSegment();
        }
        if (parser.inGroup()) {
            this.descriptor = new InGroupErrorDescriptor(parser);
            return currentIndex - parser.groupStartSegment();
        }
        if (parser.inInterchange()) {
            this.descriptor = new InInterchangeErrorDescriptor(parser);
            return currentIndex - parser.interchangeSegmentNumber();
        }
        this.descriptor = new InRootErrorDescriptor(parser);
        return currentIndex;
    }

    private boolean checkFatal(EdifactAcknowledgment.SyntaxError error, EdifactParserConfig config) {
        boolean isFatal = true;
        switch (error.code()) {
            case "21": {
                isFatal = config.charFail();
                break;
            }
            case "16": 
            case "35": 
            case "36": {
                isFatal = config.countFail();
                break;
            }
            case "39": 
            case "40": {
                isFatal = config.lengthFail();
            }
        }
        return isFatal;
    }

    public int getSegmentNumber() {
        return this.segmentNumber;
    }

    public boolean isFatal() {
        return this.isFatal;
    }

    public EdifactConstants.ErrorType getErrorType() {
        return this.errorType;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public EdifactConstants.ErrorLevel getErrorLevel() {
        return this.errorLevel;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public String getErrorDetail() {
        return this.errorDetail;
    }
}

