/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.flatfile.lexical.edifact.error.descriptor;

import com.mulesoft.flatfile.lexical.edifact.error.LexerError;
import com.mulesoft.flatfile.lexical.edifact.error.descriptor.ErrorDescriptor;
import com.mulesoft.flatfile.schema.edifact.EdifactInterchangeParser;
import com.mulesoft.flatfile.schema.model.Segment;
import com.mulesoft.flatfile.schema.model.SegmentComponent;

public abstract class BaseErrorDescriptor
implements ErrorDescriptor {
    protected int elementNumber;
    protected Segment currentSegment;
    protected int segmentIndex;
    protected String messageReference;
    protected String groupReference;
    protected String interchangeReference;
    protected int messageStartSegment;
    protected int groupStartSegment;
    protected int interchangeSegmentNumber;
    protected boolean inGroup;
    protected String valueInError;

    public BaseErrorDescriptor(EdifactInterchangeParser parser) {
        this.elementNumber = parser.lexer().getElementNumber();
        this.currentSegment = parser.currentSegment();
        this.segmentIndex = parser.segmentIndex();
        this.messageReference = parser.messageReference();
        this.groupReference = (String)parser.groupReference().getOrElse(() -> "");
        this.interchangeReference = parser.interchangeReference();
        this.messageStartSegment = parser.messageStartSegment();
        this.groupStartSegment = parser.groupStartSegment();
        this.interchangeSegmentNumber = parser.interchangeSegmentNumber();
        this.inGroup = parser.inGroup();
        this.valueInError = parser.lexer().tokenBuilder().toString();
    }

    protected String describeComponent() {
        if (this.elementNumber == 0) {
            return " past end of segment ";
        }
        int index = this.elementNumber - 1;
        if (index < this.currentSegment.components().size()) {
            SegmentComponent comp = (SegmentComponent)this.currentSegment.components().apply(index);
            return " for component " + comp.key() + ": " + comp.name() + " at segment ";
        }
        return " past end of data at segment ";
    }

    protected String getLexerError(LexerError lexerError) {
        if (lexerError != null) {
            return lexerError.buildLexerErrorDetail();
        }
        return "";
    }

    protected String describeSegment() {
        if (this.currentSegment == null) {
            return "";
        }
        return " (" + this.currentSegment.tag() + ")";
    }
}

