/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.flatfile.lexical.edifact.error;

import com.mulesoft.flatfile.lexical.EdiConstants;

public class LexerError {
    private String errorLexerText;
    private String errorLexerExplain;
    private boolean errorLexerTextHasFullMessage;
    private int elementNumber;
    private int componentNumber;
    private int subComponentNumber;
    private int repetitionNumber;
    private String token;
    private EdiConstants.ItemType type;

    public LexerError(String errorLexerExplain, boolean errorLexerTextHasFullMessage, String errorLexerText, int elementNumber, int componentNumber, int subComponentNumber, int repetitionNumber, String token, EdiConstants.ItemType type) {
        this.errorLexerText = errorLexerText;
        this.errorLexerExplain = errorLexerExplain;
        this.errorLexerTextHasFullMessage = errorLexerTextHasFullMessage;
        this.elementNumber = elementNumber;
        this.componentNumber = componentNumber;
        this.subComponentNumber = subComponentNumber;
        this.repetitionNumber = repetitionNumber;
        this.token = token;
        this.type = type;
    }

    public String buildLexerErrorDetail() {
        StringBuilder builder = new StringBuilder();
        builder.append(", ");
        if (!this.errorLexerTextHasFullMessage) {
            builder.append("at ");
            builder.append(this.describeComponent());
            builder.append(": ");
            builder.append(this.token);
            builder.append(" (");
            builder.append(this.errorLexerExplain);
            builder.append(")");
        } else {
            builder.append(this.errorLexerText);
        }
        return builder.toString();
    }

    private String describeComponent() {
        StringBuilder builder = new StringBuilder();
        String text = "element " + this.elementNumber;
        if (this.repetitionNumber > 0) {
            text = "repetition " + (this.repetitionNumber + 1) + " of " + text;
        }
        switch (this.type) {
            case SUB_COMPONENT: 
            case COMPONENT: {
                text = "component " + (this.componentNumber + 1) + " of " + text;
                if (this.type != EdiConstants.ItemType.SUB_COMPONENT) break;
                text = "subcomponent " + (this.subComponentNumber + 1) + " of " + text;
            }
        }
        builder.append(text);
        return builder.toString();
    }
}

