/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.flatfile.lexical.edifact.error.builder;

import com.mulesoft.flatfile.lexical.edifact.EdifactConstants;
import com.mulesoft.flatfile.lexical.edifact.error.BaseError;
import com.mulesoft.flatfile.lexical.edifact.error.ElementError;
import com.mulesoft.flatfile.lexical.edifact.error.GroupError;
import com.mulesoft.flatfile.lexical.edifact.error.InterchangeError;
import com.mulesoft.flatfile.lexical.edifact.error.LexerError;
import com.mulesoft.flatfile.lexical.edifact.error.NotSupportedError;
import com.mulesoft.flatfile.lexical.edifact.error.SegmentError;
import com.mulesoft.flatfile.lexical.edifact.error.TransactionError;
import com.mulesoft.flatfile.schema.edifact.EdifactAcknowledgment;
import com.mulesoft.flatfile.schema.edifact.EdifactInterchangeParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ReportBuilder {
    private static Map<Object, List<String>> typeErrorCodes = new HashMap<Object, List<String>>(){
        {
            this.put(EdifactConstants.ErrorType.ELEMENT_SYNTAX, Arrays.asList("20", "22", "13", "21", "12", "14", "17", "19", "37", "38", "39", "40"));
            this.put(EdifactConstants.ErrorType.INTERCHANGE_NOTE, Arrays.asList("7", "23", "24", "26", "43", "2", "18", "41", "42"));
            this.put(EdifactConstants.ErrorType.TRANSACTION_SYNTAX, Arrays.asList("33", "25", "27", "28", "29", "32", "34"));
            this.put(EdifactConstants.ErrorType.GROUP_SYNTAX, Arrays.asList("30", "31"));
            this.put(EdifactConstants.ErrorType.SEGMENT_SYNTAX, Arrays.asList("36", "15", "16", "35"));
        }
    };
    private static Map<Object, List<String>> levelErrorCodes = new HashMap<Object, List<String>>(){
        {
            this.put(EdifactConstants.ErrorLevel.ROOT_LEVEL, Arrays.asList("20", "22", "2", "18", "41", "42"));
            this.put(EdifactConstants.ErrorLevel.INTERCHANGE_LEVEL, Arrays.asList("13", "21", "7", "23", "24", "43", "33", "26", "30"));
            this.put(EdifactConstants.ErrorLevel.MESSAGE_LEVEL, Arrays.asList("12", "14", "17", "19", "37", "38", "39", "40", "25", "27", "28", "29", "32", "34", "15", "16", "35"));
            this.put(EdifactConstants.ErrorLevel.GROUP_LEVEL, Arrays.asList("31", "36"));
        }
    };

    public static BaseError buildEdiError(EdifactAcknowledgment.SyntaxError error, EdifactInterchangeParser parser, LexerError lexerError) {
        BaseError baseError = null;
        EdifactConstants.ErrorType type = (EdifactConstants.ErrorType)((Object)ReportBuilder.getMapEnumError(typeErrorCodes, error));
        EdifactConstants.ErrorLevel level = (EdifactConstants.ErrorLevel)((Object)ReportBuilder.getMapEnumError(levelErrorCodes, error));
        type = type == null ? EdifactConstants.ErrorType.ERROR_NOT_SUPPORTED : type;
        level = level == null ? EdifactConstants.ErrorLevel.ERROR_NOT_SUPPORTED : level;
        baseError = ReportBuilder.instanceError(type, level, error, parser, lexerError);
        return baseError;
    }

    private static Object getMapEnumError(Map<Object, List<String>> errorCodes, EdifactAcknowledgment.SyntaxError error) {
        for (Map.Entry<Object, List<String>> entry : errorCodes.entrySet()) {
            if (!entry.getValue().contains(error.code())) continue;
            return entry.getKey();
        }
        return null;
    }

    private static BaseError instanceError(EdifactConstants.ErrorType type, EdifactConstants.ErrorLevel level, EdifactAcknowledgment.SyntaxError error, EdifactInterchangeParser parser, LexerError lexerError) {
        BaseError baseError;
        switch (type) {
            case ELEMENT_SYNTAX: {
                baseError = new ElementError(level, error, parser, lexerError);
                break;
            }
            case GROUP_SYNTAX: {
                baseError = new GroupError(level, error, parser, lexerError);
                break;
            }
            case SEGMENT_SYNTAX: {
                baseError = new SegmentError(level, error, parser, lexerError);
                break;
            }
            case INTERCHANGE_NOTE: {
                baseError = new InterchangeError(level, error, parser, lexerError);
                break;
            }
            case ERROR_NOT_SUPPORTED: {
                baseError = new NotSupportedError(level, error, parser, lexerError);
                break;
            }
            default: {
                baseError = new TransactionError(level, error, parser, lexerError);
            }
        }
        return baseError;
    }

    public static void addErrorToList(String key, BaseError error, Map<String, Object> map) {
        if (map != null && error != null) {
            map.putIfAbsent(key, new ArrayList());
            ArrayList errorList = (ArrayList)map.get(key);
            errorList.add(error);
        }
    }
}

