/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.flatfile.lexical.edifact;

import com.mulesoft.flatfile.lexical.DelimiterLexer;
import com.mulesoft.flatfile.lexical.EdiConstants;
import com.mulesoft.flatfile.lexical.LexerBase;
import com.mulesoft.flatfile.lexical.LexicalException;
import com.mulesoft.flatfile.lexical.TypeFormat;
import com.mulesoft.flatfile.lexical.edifact.EdifactConstants;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EdifactLexer
extends DelimiterLexer {
    private static final TypeFormat INTER_CONTROL_COUNT_FIELD = EdifactConstants.buildType("n", 0, 6);
    private static final TypeFormat INTER_CONTROL_REF_FIELD = EdifactConstants.buildType("an", 0, 14);
    private final String delimiterDefaults;
    private final String charEncodingOverride;
    private boolean enforceCharacterSet;
    private boolean truncate;

    public EdifactLexer(InputStream is, String delims, String encoding, Boolean truncate) {
        super(is, 44);
        this.componentSeparator = (char)58;
        this.dataSeparator = (char)43;
        this.releaseIndicator = 63;
        this.segmentTerminator = (char)39;
        this.repetitionSeparator = 42;
        this.subCompSeparator = -1;
        this.delimiterDefaults = delims;
        this.charEncodingOverride = encoding;
        this.truncate = truncate;
    }

    public void configure(int subst, boolean enforce) {
        this.substitutionChar = subst;
        this.enforceCharacterSet = enforce;
    }

    public void handleEscape(StringBuilder builder) throws IOException {
        int value = this.reader.read();
        if (value >= 0) {
            char chr = (char)value;
            builder.append(chr);
        }
    }

    public InterchangeStartStatus initHeaders(Map<String, Object> props) throws IOException {
        this.init(props);
        return this.parseInterchangeAndMessageHeaders(props);
    }

    private EdifactConstants.SyntaxVersion firstTimeInit(Map<String, Object> props) throws IOException {
        EdifactConstants.SyntaxVersion version;
        byte[] byts = this.readBytes(3);
        String tag = new String(byts, EdiConstants.ASCII_CHARSET);
        boolean unaseen = false;
        if ("UNA".equals(tag)) {
            char chr;
            byts = this.readBytes(6);
            this.componentSeparator = (char)byts[0];
            this.dataSeparator = (char)byts[1];
            this.releaseIndicator = (char)byts[3];
            this.repetitionSeparator = EdifactConstants.charNonBlank((char)byts[4]);
            this.segmentTerminator = (char)byts[5];
            unaseen = true;
            while ((chr = (char)this.stream.read()) == '\n' || chr == '\r' || chr == ' ') {
            }
            ++this.segmentNumber;
            byts = new byte[3];
            byts[0] = (byte)chr;
            this.readArray(byts, 1);
            tag = new String(byts, EdiConstants.ASCII_CHARSET);
        }
        if (!"UNB".equals(tag)) {
            throw new LexicalException("Message is missing UNB segment (starts with " + tag + ")");
        }
        int ds = this.stream.read();
        String synid = new String(this.readBytes(4), EdiConstants.ASCII_CHARSET);
        props.put("UNB0101", synid);
        EdifactConstants.SyntaxIdentifier syntax = EdifactConstants.EDIFACT_CHARSETS.get(synid);
        int cs = this.stream.read();
        int verch = this.stream.read();
        switch (verch) {
            case 49: 
            case 50: {
                version = EdifactConstants.SyntaxVersion.VERSION2;
                break;
            }
            case 51: {
                version = EdifactConstants.SyntaxVersion.VERSION3;
                break;
            }
            case 52: {
                version = EdifactConstants.SyntaxVersion.VERSION4;
                break;
            }
            default: {
                throw new LexicalException("Unsupported syntax version '" + verch + '\'');
            }
        }
        props.put("UNB0102", Character.toString((char)verch));
        if (!unaseen) {
            String delims = this.delimiterDefaults == null ? version.defaultDelimiters(syntax) : this.delimiterDefaults;
            this.dataSeparator = delims.charAt(0);
            this.componentSeparator = delims.charAt(1);
            this.repetitionSeparator = EdifactConstants.charNonBlank(delims.charAt(2));
            this.segmentTerminator = delims.charAt(3);
            this.releaseIndicator = EdifactConstants.charNonBlank(delims.charAt(4));
        }
        if (ds != this.dataSeparator) {
            throw new LexicalException("Wrong delimiter for syntax version (expected '" + this.dataSeparator + "', found '" + ds + '\'');
        }
        if (cs != this.componentSeparator) {
            throw new LexicalException("Wrong delimiter for syntax version (expected '" + this.componentSeparator + "', found '" + cs + '\'');
        }
        int chr = this.stream.read();
        String codelist = null;
        String charenc = null;
        Charset charset = syntax.defaultCharSet();
        if (version == EdifactConstants.SyntaxVersion.VERSION4 && chr == this.componentSeparator) {
            StringBuilder builder = new StringBuilder();
            while ((chr = this.stream.read()) >= 0 && chr != this.componentSeparator && chr != this.dataSeparator && chr != this.segmentTerminator) {
                builder.append((char)chr);
            }
            codelist = builder.toString();
            props.put("UNB0103", codelist);
            if (chr == this.componentSeparator) {
                builder.setLength(0);
                while ((chr = this.stream.read()) >= 0 && chr != this.componentSeparator && chr != this.dataSeparator && chr != this.segmentTerminator) {
                    builder.append((char)chr);
                }
                charenc = builder.toString();
                props.put("UNB0104", charenc);
                if (charenc.length() == 1) {
                    char code = charenc.charAt(0);
                    try {
                        switch (code) {
                            case '1': 
                            case '2': {
                                charset = EdiConstants.ASCII_CHARSET;
                                break;
                            }
                            case '3': {
                                charset = Charset.forName("Cp1148");
                                break;
                            }
                            case '4': {
                                charset = Charset.forName("Cp858");
                                break;
                            }
                            case '7': {
                                charset = EdifactConstants.UTF8;
                                break;
                            }
                            case '8': {
                                charset = Charset.forName("UTF-16");
                                break;
                            }
                            default: {
                                throw new RuntimeException("Unknown character encoding '" + code + "'");
                            }
                        }
                    }
                    catch (Exception e) {
                        throw new LexicalException("Unsupported character encoding '" + code + '\'', (Throwable)e);
                    }
                } else if (!"ZZZ".equals(charenc)) {
                    throw new LexicalException("Unknown character encoding code '" + charenc + '\'');
                }
            }
        }
        if (this.charEncodingOverride != null) {
            try {
                charset = Charset.forName(this.charEncodingOverride);
            }
            catch (Exception e) {
                throw new LexicalException("Invalid character encoding override '" + this.charEncodingOverride + '\'', (Throwable)e);
            }
        }
        if (charset == null) {
            throw new LexicalException("Unsupported syntax identifier '" + synid + "' (character encoding not supported)");
        }
        this.allowedChars = this.enforceCharacterSet ? syntax.flags() : null;
        this.reader = new BufferedReader(new InputStreamReader(this.stream, charset));
        ++this.elementNumber;
        this.advance(EdiConstants.ItemType.DATA_ELEMENT);
        return version;
    }

    private EdifactConstants.SyntaxVersion subsequentInit(Map<String, Object> props) throws IOException {
        EdifactConstants.SyntaxVersion version;
        if ("UNA".equals(this.segmentTag())) {
            throw new LexicalException("UNA is only allowed for first interchange");
        }
        if (!"UNB".equals(this.segmentTag())) {
            throw new LexicalException("Message is missing UNB segment (starts with " + this.segmentTag() + ")");
        }
        this.advance();
        String synid = this.tokenBuilder.toString();
        props.put("UNB0101", synid);
        EdifactConstants.SyntaxIdentifier syntax = EdifactConstants.EDIFACT_CHARSETS.get(synid);
        this.advance();
        char verch = this.tokenBuilder.charAt(0);
        switch (verch) {
            case '1': 
            case '2': {
                version = EdifactConstants.SyntaxVersion.VERSION2;
                break;
            }
            case '3': {
                version = EdifactConstants.SyntaxVersion.VERSION3;
                break;
            }
            case '4': {
                version = EdifactConstants.SyntaxVersion.VERSION4;
                break;
            }
            default: {
                throw new LexicalException("Unsupported syntax version '" + verch + '\'');
            }
        }
        props.put("UNB0102", Character.toString(verch));
        while (this.currentType() != EdiConstants.ItemType.DATA_ELEMENT) {
            this.advance();
        }
        this.allowedChars = this.enforceCharacterSet ? syntax.flags() : null;
        return version;
    }

    private InterchangeStartStatus parseInterchangeHeader(Map<String, Object> props) throws IOException {
        InterchangeStartStatus result = InterchangeStartStatus.VALID;
        result = this.parseComponent(result, "UNB0201", EdifactConstants.VAL_AN_0_35, props, InterchangeStartStatus.SENDER_ID_ERROR);
        this.advance();
        if (this.currentType == EdiConstants.ItemType.COMPONENT) {
            result = this.parseComponent(result, "UNB0202", EdifactConstants.VAL_AN_0_4, props, InterchangeStartStatus.SENDER_ID_QUALIFIER_ERROR);
            this.advance();
        }
        if (this.currentType == EdiConstants.ItemType.COMPONENT) {
            result = this.parseComponent(result, "UNB0203", EdifactConstants.VAL_AN_0_35, props, InterchangeStartStatus.SENDER_ADDRESS_OR_INTERNAL_ID_ERROR);
            this.advance();
            if (this.currentType == EdiConstants.ItemType.COMPONENT) {
                result = this.parseComponent(result, "UNB0204", EdifactConstants.VAL_AN_0_35, props, InterchangeStartStatus.SENDER_INTERNAL_SUB_ID_ERROR);
                this.advance();
            }
        }
        result = this.parseComponent(result, "UNB0301", EdifactConstants.VAL_AN_0_35, props, InterchangeStartStatus.RECEIVER_ID_ERROR);
        this.advance();
        if (this.currentType == EdiConstants.ItemType.COMPONENT) {
            result = this.parseComponent(result, "UNB0302", EdifactConstants.VAL_AN_0_4, props, InterchangeStartStatus.RECEIVER_ID_QUALIFIER_ERROR);
            this.advance();
        }
        if (this.currentType == EdiConstants.ItemType.COMPONENT) {
            result = this.parseComponent(result, "UNB0303", EdifactConstants.VAL_AN_0_35, props, InterchangeStartStatus.RECEIVER_ADDRESS_OR_INTERNAL_ID_ERROR);
            this.advance();
            if (this.currentType == EdiConstants.ItemType.COMPONENT) {
                result = this.parseComponent(result, "UNB0304", EdifactConstants.VAL_AN_0_35, props, InterchangeStartStatus.RECEIVER_INTERNAL_SUB_ID_ERROR);
                this.advance();
            }
        }
        result = this.parseComponent(result, "UNB0401", EdifactConstants.VAL_N_6_8, props, InterchangeStartStatus.PREPARATION_DATE_ERROR);
        this.advance();
        result = this.parseComponent(result, "UNB0402", EdifactConstants.VAL_N_4, props, InterchangeStartStatus.PREPARATION_TIME_ERROR);
        this.advance();
        result = this.parseComponent(result, "UNB05", EdifactConstants.VAL_AN_0_14, props, InterchangeStartStatus.INTERCHANGE_CONTROL_ERROR);
        this.advance();
        if (this.currentType == EdiConstants.ItemType.DATA_ELEMENT) {
            result = this.parseComponent(result, "UNB0601", EdifactConstants.VAL_AN_0_14, props, InterchangeStartStatus.RECEIVER_PASS_ERROR);
            this.advance();
            if (this.currentType == EdiConstants.ItemType.COMPONENT) {
                result = this.parseComponent(result, "UNB0602", EdifactConstants.VAL_AN_2, props, InterchangeStartStatus.RECEIVER_PASS_QUALIFIER_ERROR);
                this.advance();
            }
        }
        if (this.currentType == EdiConstants.ItemType.DATA_ELEMENT) {
            result = this.parseComponent(result, "UNB07", EdifactConstants.VAL_AN_0_14, props, InterchangeStartStatus.APP_REFERENCE_ERROR);
            this.advance();
        }
        if (this.currentType == EdiConstants.ItemType.DATA_ELEMENT) {
            result = this.parseComponent(result, "UNB08", EdifactConstants.VAL_A_1, props, InterchangeStartStatus.PROCESSING_CODE_ERROR);
            this.advance();
        }
        if (this.currentType == EdiConstants.ItemType.DATA_ELEMENT) {
            result = this.parseComponent(result, "UNB09", EdifactConstants.VAL_N_1, props, InterchangeStartStatus.ACK_REQUEST_ERROR);
            this.advance();
        }
        if (this.currentType == EdiConstants.ItemType.DATA_ELEMENT) {
            result = this.parseComponent(result, "UNB10", EdifactConstants.VAL_AN_0_35, props, InterchangeStartStatus.AGREEMENT_ID_ERROR);
            this.advance();
        }
        if (this.currentType == EdiConstants.ItemType.DATA_ELEMENT) {
            result = this.parseComponent(result, "UNB11", EdifactConstants.VAL_N_1, props, InterchangeStartStatus.TEST_INDICATOR_ERROR);
            this.advance();
        }
        return result;
    }

    public InterchangeStartStatus parseInterchangeAndMessageHeaders(Map<String, Object> props) throws IOException {
        InterchangeStartStatus result = this.parseInterchangeHeader(props);
        if (result == InterchangeStartStatus.VALID) {
            try {
                ArrayList<Map<String, Object>> msgHeaders = new ArrayList<Map<String, Object>>();
                this.parseMessageHeaders(msgHeaders);
                if (msgHeaders.size() > 0) {
                    props.put("TransactionSets", msgHeaders);
                }
            }
            catch (IOException e) {
                logger.error("Error reading interchange data", (Throwable)e);
            }
        }
        return result;
    }

    private void parseMessageHeaders(List<Map<String, Object>> headersList) throws IOException {
        this.toSegment();
        if (!"UNH".equals(this.segmentTag())) {
            throw new LexicalException("Message is missing UNH segment (found '" + this.segmentTag() + "')");
        }
        while (EdiConstants.ItemType.END != this.currentType) {
            if ("UNH".equals(this.segmentTag)) {
                HashMap<String, Object> msgHeader = new HashMap<String, Object>();
                this.parseMsgHeader(msgHeader);
                headersList.add(msgHeader);
            } else if ("UNZ".equals(this.segmentTag())) break;
            this.nextSegment();
        }
    }

    private void parseMsgHeader(Map<String, Object> header) throws IOException {
        try {
            this.advance();
            header.put("UNH01", EdifactConstants.VAL_AN_0_14.parse((LexerBase)this));
            this.advance();
            header.put("UNH0201", EdifactConstants.VAL_AN_0_6.parse((LexerBase)this));
            this.advance();
            header.put("UNH0202", EdifactConstants.VAL_AN_0_3.parse((LexerBase)this));
            this.advance();
            header.put("UNH0203", EdifactConstants.VAL_AN_0_3.parse((LexerBase)this));
            this.advance();
            header.put("UNH0204", EdifactConstants.VAL_AN_0_3.parse((LexerBase)this));
            this.advance();
            if (this.currentType == EdiConstants.ItemType.COMPONENT) {
                header.put("UNH0205", EdifactConstants.VAL_AN_0_6.parse((LexerBase)this));
            }
        }
        catch (LexicalException e) {
            throw new IOException("Error reading GS segment", e);
        }
    }

    private InterchangeStartStatus parseComponent(InterchangeStartStatus status, String component, TypeFormat format, Map<String, Object> props, InterchangeStartStatus caseError) throws IOException {
        InterchangeStartStatus nextResult = status;
        try {
            props.put(component, format.parse((LexerBase)this));
        }
        catch (LexicalException e) {
            nextResult = EdifactLexer.replaceValidStatus(status, caseError);
        }
        return nextResult;
    }

    private void toSegment() throws IOException {
        while (EdiConstants.ItemType.SEGMENT != this.currentType && EdiConstants.ItemType.END != this.currentType) {
            this.advance();
        }
    }

    private void nextSegment() throws IOException {
        if (EdiConstants.ItemType.SEGMENT == this.currentType) {
            this.advance();
        }
        this.toSegment();
    }

    private static InterchangeStartStatus replaceValidStatus(InterchangeStartStatus status, InterchangeStartStatus replace) {
        if (status == InterchangeStartStatus.VALID) {
            return replace;
        }
        return status;
    }

    public boolean isInitialized() {
        return this.reader != null;
    }

    public EdifactConstants.SyntaxVersion init(Map<String, Object> props) throws LexicalException {
        try {
            if (this.reader == null) {
                return this.firstTimeInit(props);
            }
            return this.subsequentInit(props);
        }
        catch (IOException e) {
            throw new LexicalException("Interchange aborted due to error reading header", (Throwable)e);
        }
    }

    public void term(Map<String, Object> props) throws IOException {
        if (!"UNZ".equals(this.segmentTag())) {
            throw new IllegalStateException("not at trailer");
        }
        if (this.nextType() == EdiConstants.ItemType.DATA_ELEMENT) {
            this.advance();
            props.put("UNZ01", INTER_CONTROL_COUNT_FIELD.parse((LexerBase)this));
            if (this.nextType() == EdiConstants.ItemType.DATA_ELEMENT) {
                this.advance();
                props.put("UNZ02", INTER_CONTROL_REF_FIELD.parse((LexerBase)this));
            }
        }
    }

    public boolean applyTruncation(TypeFormat typeFormat) {
        return this.truncate;
    }

    public static enum InterchangeStartStatus {
        VALID,
        SENDER_ID_ERROR,
        SENDER_ID_QUALIFIER_ERROR,
        SENDER_ADDRESS_OR_INTERNAL_ID_ERROR,
        SENDER_INTERNAL_SUB_ID_ERROR,
        RECEIVER_ADDRESS_OR_INTERNAL_ID_ERROR,
        RECEIVER_INTERNAL_SUB_ID_ERROR,
        RECEIVER_ID_ERROR,
        RECEIVER_ID_QUALIFIER_ERROR,
        PREPARATION_DATE_ERROR,
        PREPARATION_TIME_ERROR,
        INTERCHANGE_CONTROL_ERROR,
        RECEIVER_PASS_ERROR,
        RECEIVER_PASS_QUALIFIER_ERROR,
        APP_REFERENCE_ERROR,
        PROCESSING_CODE_ERROR,
        ACK_REQUEST_ERROR,
        AGREEMENT_ID_ERROR,
        TEST_INDICATOR_ERROR,
        NO_DATA;

    }
}

