/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.flatfile.lexical.edifact.error.builder;

import com.mulesoft.flatfile.lexical.edifact.EdifactConstants;
import com.mulesoft.flatfile.lexical.edifact.error.EdifactError;
import com.mulesoft.flatfile.lexical.edifact.error.LexerError;
import com.mulesoft.flatfile.lexical.edifact.error.descriptor.ErrorDescriptor;
import com.mulesoft.flatfile.lexical.edifact.error.descriptor.InCodeSetErrorDescriptor;
import com.mulesoft.flatfile.lexical.edifact.error.descriptor.InGroupErrorDescriptor;
import com.mulesoft.flatfile.lexical.edifact.error.descriptor.InInterchangeErrorDescriptor;
import com.mulesoft.flatfile.lexical.edifact.error.descriptor.InMessageErrorDescriptor;
import com.mulesoft.flatfile.lexical.edifact.error.descriptor.InRootErrorDescriptor;
import com.mulesoft.flatfile.schema.edifact.EdifactAcknowledgment;
import com.mulesoft.flatfile.schema.edifact.EdifactInterchangeParser;
import com.mulesoft.flatfile.schema.edifact.EdifactSchemaWriter;

public class ErrorBuilder {
    private EdifactAcknowledgment.SyntaxError syntaxError;
    private String errorText;
    private String errorCode;
    private String errorDetails;
    private boolean fatal = true;
    private LexerError lexerError;
    private EdifactConstants.ErrorType errorType;
    private EdifactConstants.ErrorLevel errorLevel;
    private ErrorDescriptor descriptor;

    public ErrorBuilder withSyntaxError(EdifactAcknowledgment.SyntaxError syntaxError) {
        this.syntaxError = syntaxError;
        return this;
    }

    public ErrorBuilder withErrorText(String errorText) {
        this.errorText = errorText;
        return this;
    }

    public ErrorBuilder withErrorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    public ErrorBuilder withErrorDetails(String errorDetails) {
        this.errorDetails = errorDetails;
        return this;
    }

    public ErrorBuilder withFatalness(boolean fatal) {
        this.fatal = fatal;
        return this;
    }

    public ErrorBuilder withLexerError(LexerError lexerError) {
        this.lexerError = lexerError;
        return this;
    }

    public ErrorBuilder withErrorType(EdifactConstants.ErrorType errorType) {
        this.errorType = errorType;
        return this;
    }

    public ErrorBuilder withErrorLevel(EdifactConstants.ErrorLevel errorLevel) {
        this.errorLevel = errorLevel;
        return this;
    }

    private int getErrorSegmentNumber(EdifactInterchangeParser parser) {
        int currentIndex = parser.segmentNumber();
        if (parser.inMessage()) {
            this.descriptor = parser.inCodeSet() ? new InCodeSetErrorDescriptor(parser) : new InMessageErrorDescriptor(parser);
            return currentIndex - parser.messageStartSegment();
        }
        if (parser.inGroup()) {
            this.descriptor = new InGroupErrorDescriptor(parser);
            return currentIndex - parser.groupStartSegment();
        }
        if (parser.inInterchange()) {
            this.descriptor = new InInterchangeErrorDescriptor(parser);
            return currentIndex - parser.interchangeSegmentNumber();
        }
        this.descriptor = new InRootErrorDescriptor(parser);
        return currentIndex;
    }

    public EdifactError buildError(EdifactInterchangeParser parser) {
        EdifactError edifactError = this.buildError();
        int segmentNumber = this.getErrorSegmentNumber(parser);
        edifactError.setSegmentNumber(segmentNumber);
        edifactError.setSegmentTag(parser.segmentTag());
        edifactError.setErrorCode(this.syntaxError.code());
        String text = String.format(this.syntaxError.text(), "");
        edifactError.setErrorText(text);
        edifactError.setInterchangeId(parser.interchangeSegmentNumber());
        edifactError.setMessageId((String)parser.currentMessage().getOrElse(() -> ""));
        String details = this.descriptor.buildDetail(this.fatal, this.syntaxError.text(), segmentNumber, this.lexerError);
        edifactError.setErrorDetails(details);
        edifactError.setInterchangeControlReference(parser.interchangeReference());
        edifactError.setMessageControlReference(parser.messageReference());
        edifactError.setGroupControlReference(parser.groupReference());
        return edifactError;
    }

    public EdifactError buildError(EdifactSchemaWriter writer) {
        EdifactError edifactError = this.buildError();
        edifactError.setSegmentNumber(writer.writer().getSegmentCount());
        edifactError.setSegmentTag(writer.segmentTag());
        edifactError.setErrorCode(this.errorCode);
        edifactError.setErrorText(this.errorText);
        edifactError.setInterchangeId((Integer)writer.currentInterchange().getOrElse(() -> -1));
        edifactError.setMessageId((String)writer.currentMessage().getOrElse(() -> ""));
        edifactError.setErrorDetails(this.errorDetails);
        return edifactError;
    }

    private EdifactError buildError() {
        EdifactError edifactError = new EdifactError();
        edifactError.setFatal(this.fatal);
        edifactError.setErrorType(this.errorType);
        edifactError.setErrorLevel(this.errorLevel);
        return edifactError;
    }
}

