/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.flatfile.lexical.edifact.error.descriptor;

import com.mulesoft.flatfile.lexical.edifact.error.LexerError;
import com.mulesoft.flatfile.lexical.edifact.error.descriptor.BaseErrorDescriptor;
import com.mulesoft.flatfile.schema.edifact.EdifactInterchangeParser;
import com.mulesoft.flatfile.schema.model.SegmentComponent;

public class InCodeSetErrorDescriptor
extends BaseErrorDescriptor {
    public InCodeSetErrorDescriptor(EdifactInterchangeParser parser) {
        super(parser);
    }

    @Override
    public String buildDetail(boolean isFatal, String errorText, int segmentNumber, LexerError lexerError) {
        StringBuilder builder = new StringBuilder();
        String value = this.valueInError + " ";
        builder.append(String.format(errorText, value)).append(this.describeComponent()).append(segmentNumber + 1).append(this.getLexerError(lexerError)).append(this.getPosition());
        return builder.toString();
    }

    @Override
    public String getPosition() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.positionMessageNumber()).append(this.positionGroupNumber()).append(" of interchange ").append(this.interchangeReference);
        return builder.toString();
    }

    private String positionMessageNumber() {
        if (this.messageReference != null && !this.messageReference.isEmpty()) {
            return " in message " + this.messageReference;
        }
        return "";
    }

    private String positionGroupNumber() {
        if (this.inGroup && !this.groupReference.isEmpty()) {
            return " in group " + this.groupReference;
        }
        return "";
    }

    @Override
    protected String describeComponent() {
        if (this.elementNumber == 0) {
            return " past end of segment ";
        }
        int index = this.elementNumber - 1;
        if (index < this.currentSegment.components().size()) {
            SegmentComponent comp = (SegmentComponent)this.currentSegment.components().apply(index);
            return " " + comp.key() + ": " + comp.name() + " at segment ";
        }
        return " past end of data at segment ";
    }
}

