/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.flatfile.lexical.edifact;

import com.mulesoft.flatfile.lexical.EdiConstants;
import com.mulesoft.flatfile.lexical.TypeFormat;
import com.mulesoft.flatfile.lexical.TypeFormatConstants;
import com.mulesoft.flatfile.lexical.formats.ExplicitDecimalFormat;
import com.mulesoft.flatfile.lexical.formats.RestrictedCharacterStringFormat;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

public final class EdifactConstants {
    public static final String SYNTAX_IDENTIFIER = "UNB0101";
    public static final String SYNTAX_VERSION_NUMBER = "UNB0102";
    public static final String SERVICE_CODE_LIST = "UNB0103";
    public static final String CHARACTER_ENCODING = "UNB0104";
    public static final String SENDER_ID = "UNB0201";
    public static final String SENDER_ID_QUALIFIER = "UNB0202";
    public static final String SENDER_ADDRESS_OR_INTERNAL_ID = "UNB0203";
    public static final String SENDER_INTERNAL_SUB_ID = "UNB0204";
    public static final String RECEIVER_ID = "UNB0301";
    public static final String RECEIVER_ID_QUALIFIER = "UNB0302";
    public static final String RECEIVER_ADDRESS_OR_INTERNAL_ID = "UNB0303";
    public static final String RECEIVER_INTERNAL_SUB_ID = "UNB0304";
    public static final String PREPARATION_DATE = "UNB0401";
    public static final String PREPARATION_TIME = "UNB0402";
    public static final String INTERCHANGE_CONTROL = "UNB05";
    public static final String RECEIVER_PASS = "UNB0601";
    public static final String RECEIVER_PASS_QUALIFIER = "UNB0602";
    public static final String APP_REFERENCE = "UNB07";
    public static final String PROCESSING_CODE = "UNB08";
    public static final String ACK_REQUEST = "UNB09";
    public static final String AGREEMENT_ID = "UNB10";
    public static final String TEST_INDICATOR = "UNB11";
    public static final String MESSAGE_NUMBER = "UNH01";
    public static final String MESSAGE_TYPE = "UNH0201";
    public static final String MESSAGE_VERSION_NUMBER = "UNH0202";
    public static final String MESSAGE_RELEASE_NUMBER = "UNH0203";
    public static final String CONTROLLING_AGENCY_CODED = "UNH0204";
    public static final String ASSOCIATION_CODE = "UNH0205";
    public static final String FORCE_UNA = "forceUNA";
    public static final String INTER_CONTROL_COUNT = "UNZ01";
    public static final String INTER_CONTROL_REF = "UNZ02";
    public static final boolean[] levelACharacterSet = new boolean[128];
    public static final boolean[] levelBCharacterSet;
    public static final boolean[] alphaNumerics;
    public static final boolean[] plainAlphas;
    public static final Charset UTF8;
    private static Charset ISO88591_CHARSET;
    public static final SyntaxIdentifier LEVELA;
    public static final SyntaxIdentifier LEVELB;
    public static final SyntaxIdentifier LEVELC;
    public static final SyntaxIdentifier LEVELW;
    public static final SyntaxIdentifier LEVELY;
    public static final SyntaxIdentifier IATB;
    public static final Map<String, SyntaxIdentifier> EDIFACT_CHARSETS;
    private static final String basicDelimiters = "+: '?";
    private static final String alternateDelimiters = "\u001d\u001f \u001c ";
    private static final String version4Delimiters = "+:*'?";
    public static final Map<String, SyntaxVersion> EDIFACT_VERSIONS;
    public static final TypeFormat VAL_AN_0_3;
    public static final TypeFormat VAL_AN_0_4;
    public static final TypeFormat VAL_AN_0_6;
    public static final TypeFormat VAL_AN_0_14;
    public static final TypeFormat VAL_AN_0_35;
    public static final TypeFormat VAL_AN_2;
    public static final TypeFormat VAL_N_1;
    public static final TypeFormat VAL_N_4;
    public static final TypeFormat VAL_N_6_8;
    public static final TypeFormat VAL_A_1;

    public static void addSyntax(String code, String chname) {
        try {
            Charset chset = Charset.forName(chname);
            SyntaxIdentifier synid = new SyntaxIdentifier(code, chset, null);
            EDIFACT_CHARSETS.put(code, synid);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static int charNonBlank(char chr) {
        return chr == ' ' ? -1 : (int)chr;
    }

    public static int handleSeparatorChar(boolean forceSpaceSeparator, char chr) {
        return forceSpaceSeparator ? chr : EdifactConstants.charNonBlank((char)chr);
    }

    public static String typeName(String type, int minLength, int maxLength) {
        if (minLength == maxLength) {
            return type + maxLength;
        }
        if (minLength != 0) {
            throw new IllegalArgumentException("No support for non-zero based size range");
        }
        return type + ".." + maxLength;
    }

    public static TypeFormat buildType(String type, int minLength, int maxLength) {
        String norm = type.toLowerCase();
        if ("an".equals(norm)) {
            return new RestrictedCharacterStringFormat(type, minLength, maxLength, TypeFormatConstants.FillMode.LEFT, alphaNumerics, true);
        }
        if ("n".equals(norm)) {
            return new ExplicitDecimalFormat(type, minLength, maxLength, TypeFormatConstants.NumberSign.NEGATIVE_ONLY, false, TypeFormatConstants.FillMode.ZEROES, false, true, false, false);
        }
        if ("a".equals(norm)) {
            return new RestrictedCharacterStringFormat(type, minLength, maxLength, TypeFormatConstants.FillMode.LEFT, plainAlphas, true);
        }
        throw new IllegalArgumentException("Unknown EDIFACT type code " + type);
    }

    static {
        EdiConstants.fillChars((char)'A', (char)'Z', (boolean[])levelACharacterSet);
        EdiConstants.fillChars((char)'0', (char)'9', (boolean[])levelACharacterSet);
        EdiConstants.setChars((char[])" .,-()/=,+:?!\"%&*;<>".toCharArray(), (boolean[])levelACharacterSet);
        levelBCharacterSet = new boolean[128];
        System.arraycopy(levelACharacterSet, 0, levelBCharacterSet, 0, levelACharacterSet.length);
        EdiConstants.fillChars((char)'a', (char)'z', (boolean[])levelBCharacterSet);
        EdiConstants.setChars((char[])" .,-()/'+:=?!\"%&*;<>\f\r\u000f".toCharArray(), (boolean[])levelBCharacterSet);
        alphaNumerics = new boolean[128];
        EdiConstants.fillChars((char)' ', (char)'\u007f', (boolean[])alphaNumerics);
        plainAlphas = new boolean[128];
        EdifactConstants.plainAlphas[32] = true;
        EdiConstants.fillChars((char)'a', (char)'z', (boolean[])plainAlphas);
        EdiConstants.fillChars((char)'A', (char)'Z', (boolean[])plainAlphas);
        UTF8 = Charset.forName("UTF-8");
        ISO88591_CHARSET = Charset.forName("ISO8859_1");
        LEVELA = new SyntaxIdentifier("UNOA", EdiConstants.ASCII_CHARSET, levelACharacterSet);
        LEVELB = new SyntaxIdentifier("UNOB", EdiConstants.ASCII_CHARSET, levelBCharacterSet);
        LEVELC = new SyntaxIdentifier("UNOC", ISO88591_CHARSET, null);
        LEVELW = new SyntaxIdentifier("UNOW", EdiConstants.UTF8_CHARSET, null);
        LEVELY = new SyntaxIdentifier("UNOY", EdiConstants.UTF8_CHARSET, null);
        IATB = new SyntaxIdentifier("IATB", ISO88591_CHARSET, null);
        EDIFACT_CHARSETS = new HashMap<String, SyntaxIdentifier>();
        EDIFACT_CHARSETS.put(LEVELA.syntaxCode, LEVELA);
        EDIFACT_CHARSETS.put(LEVELB.syntaxCode, LEVELB);
        EDIFACT_CHARSETS.put(LEVELC.syntaxCode, LEVELC);
        EDIFACT_CHARSETS.put(LEVELW.syntaxCode, LEVELW);
        EDIFACT_CHARSETS.put(LEVELY.syntaxCode, LEVELY);
        EDIFACT_CHARSETS.put(IATB.syntaxCode, IATB);
        EdifactConstants.addSyntax("UNOD", "ISO8859_2");
        EdifactConstants.addSyntax("UNOE", "ISO8859_5");
        EdifactConstants.addSyntax("UNOF", "ISO8859_7");
        EdifactConstants.addSyntax("UNOG", "ISO8859_3");
        EdifactConstants.addSyntax("UNOH", "ISO8859_4");
        EdifactConstants.addSyntax("UNOI", "ISO8859_6");
        EdifactConstants.addSyntax("UNOJ", "ISO8859_8");
        EdifactConstants.addSyntax("UNOK", "ISO8859_9");
        EdifactConstants.addSyntax("UNOX", "ISO2375");
        EDIFACT_VERSIONS = new HashMap<String, SyntaxVersion>();
        for (SyntaxVersion version : SyntaxVersion.values()) {
            EDIFACT_VERSIONS.put(version.code(), version);
        }
        VAL_AN_0_3 = EdifactConstants.buildType("an", 0, 3);
        VAL_AN_0_4 = EdifactConstants.buildType("an", 0, 4);
        VAL_AN_0_6 = EdifactConstants.buildType("an", 0, 6);
        VAL_AN_0_14 = EdifactConstants.buildType("an", 0, 14);
        VAL_AN_0_35 = EdifactConstants.buildType("an", 0, 35);
        VAL_AN_2 = EdifactConstants.buildType("an", 2, 2);
        VAL_N_1 = EdifactConstants.buildType("n", 1, 1);
        VAL_N_4 = EdifactConstants.buildType("n", 4, 4);
        VAL_N_6_8 = EdifactConstants.buildType("n", 6, 8);
        VAL_A_1 = EdifactConstants.buildType("a", 1, 1);
    }

    public static enum ErrorType {
        INTERCHANGE_NOTE,
        GROUP_SYNTAX,
        MESSAGE_SYNTAX,
        SEGMENT_SYNTAX,
        ELEMENT_SYNTAX,
        ERROR_NOT_SUPPORTED;

    }

    public static enum ErrorLevel {
        ROOT_LEVEL,
        INTERCHANGE_LEVEL,
        GROUP_LEVEL,
        MESSAGE_LEVEL,
        ERROR_NOT_SUPPORTED;

    }

    public static enum SyntaxVersion {
        VERSION1("1"),
        VERSION2("2"),
        VERSION3("3"),
        VERSION4("4");

        private final String codeValue;

        private SyntaxVersion(String code) {
            this.codeValue = code;
        }

        public String code() {
            return this.codeValue;
        }

        public String defaultDelimiters(SyntaxIdentifier sid) {
            if (this == VERSION4) {
                return EdifactConstants.version4Delimiters;
            }
            if (sid == LEVELA) {
                return EdifactConstants.basicDelimiters;
            }
            return EdifactConstants.alternateDelimiters;
        }
    }

    public static class SyntaxIdentifier {
        private final String syntaxCode;
        private final Charset defaultCharset;
        private final boolean[] characterFlags;

        SyntaxIdentifier(String code, Charset chset, boolean[] flags) {
            this.syntaxCode = code;
            this.defaultCharset = chset;
            this.characterFlags = flags;
        }

        public String code() {
            return this.syntaxCode;
        }

        public Charset defaultCharSet() {
            return this.defaultCharset;
        }

        public boolean[] flags() {
            return this.characterFlags;
        }
    }
}

