/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.edifact.extension.internal.config;

import com.mulesoft.connectors.edifact.extension.internal.operation.EdifactOperations;
import com.mulesoft.connectors.edifactpre.extension.api.config.CharacterEncoding;
import com.mulesoft.connectors.edifactpre.extension.internal.config.AbstractEdifactConfig;
import com.mulesoft.connectors.edifactpre.extension.internal.connection.Provider;
import java.nio.charset.Charset;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Configuration;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.connectivity.ConnectionProviders;
import org.mule.runtime.extension.api.annotation.param.DefaultEncoding;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

@ConnectionProviders(value={Provider.class})
@Operations(value={EdifactOperations.class})
@Configuration(name="config")
public class EdifactConfig
extends AbstractEdifactConfig {
    @Parameter
    @Optional(defaultValue="PLATFORM")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Character encoding")
    @Placement(order=2)
    @Summary(value="Character encoding used for both send and receive messages")
    private CharacterEncoding characterEncoding;
    private Charset charset;
    @DefaultEncoding
    private String muleEncoding;

    public CharacterEncoding getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(CharacterEncoding characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public void initialise() throws InitialisationException {
        if (CharacterEncoding.PLATFORM == this.characterEncoding) {
            if (this.muleEncoding == null) {
                throw new RuntimeException("No default encoding for platform");
            }
            this.charset = Charset.forName(this.muleEncoding);
        } else {
            this.charset = this.characterEncoding.characterSet;
        }
    }

    public Charset getCharset() {
        return this.charset;
    }
}

