/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.edifact.extension.internal.config;

import com.mulesoft.connectors.edifact.extension.internal.operation.EdifactPreOperations;
import com.mulesoft.connectors.edifactpre.extension.api.config.CharacterEncoding;
import com.mulesoft.connectors.edifactpre.extension.api.config.SeparatorUsage;
import com.mulesoft.connectors.edifactpre.extension.internal.config.AbstractEdifactConfig;
import com.mulesoft.connectors.edifactpre.extension.internal.connection.Provider;
import java.nio.charset.Charset;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Configuration;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.connectivity.ConnectionProviders;
import org.mule.runtime.extension.api.annotation.param.DefaultEncoding;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

@ConnectionProviders(value={Provider.class})
@Operations(value={EdifactPreOperations.class})
@Configuration(name="config")
public class EdifactPreConfig
extends AbstractEdifactConfig {
    @Parameter
    @Optional(defaultValue="PLATFORM")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @DisplayName(value="Character encoding")
    @Placement(order=2)
    @Summary(value="Character encoding used for both send and receive messages")
    private CharacterEncoding characterEncoding;
    @Parameter
    @Optional(defaultValue="USE_SPECIFIED_FOR_ALL")
    @Placement(order=3)
    @DisplayName(value="Separators usage")
    @Summary(value="Usage of specified separator/release characters")
    private SeparatorUsage separatorUsage;
    @Parameter
    @Optional(defaultValue="+")
    @Placement(order=4)
    @DisplayName(value="Data element separator")
    @Summary(value="Data element separator character")
    private String dataSeparator;
    @Parameter
    @Optional(defaultValue=":")
    @Placement(order=5)
    @DisplayName(value="Component element separator")
    @Summary(value="Component element separator character")
    private String componentSeparator;
    @Parameter
    @Optional(defaultValue="*")
    @Placement(order=6)
    @DisplayName(value="Repetition separator")
    @Summary(value="Repetition separator character")
    private String repetitionSeparator;
    @Parameter
    @Optional(defaultValue="'")
    @Placement(order=7)
    @DisplayName(value="Segment terminator")
    @Summary(value="Segment terminator character")
    private String segmentTerminator;
    @Parameter
    @Optional(defaultValue="?")
    @Placement(order=8)
    @DisplayName(value="Release character")
    @Summary(value="Release character")
    private String releaseCharacter;
    private Charset charset;
    @DefaultEncoding
    private String muleEncoding;

    public CharacterEncoding getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(CharacterEncoding characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public void initialise() throws InitialisationException {
        if (CharacterEncoding.PLATFORM == this.characterEncoding) {
            if (this.muleEncoding == null) {
                throw new RuntimeException("No default encoding for platform");
            }
            this.charset = Charset.forName(this.muleEncoding);
        } else {
            this.charset = this.characterEncoding.characterSet;
        }
    }

    public Charset getCharset() {
        return this.charset;
    }

    public SeparatorUsage getSeparatorUsage() {
        return this.separatorUsage;
    }

    public String getDataSeparator() {
        return this.dataSeparator;
    }

    public String getComponentSeparator() {
        return this.componentSeparator;
    }

    public String getRepetitionSeparator() {
        return this.repetitionSeparator;
    }

    public String getSegmentTerminator() {
        return this.segmentTerminator;
    }

    public String getReleaseCharacter() {
        return this.releaseCharacter;
    }

    private void validateSeparator(String name, String value) {
        if (value == null || value.length() != 1) {
            throw new RuntimeException(name + " value must be a single character");
        }
        char delim = value.charAt(0);
        if (Character.isAlphabetic(delim) || Character.isDigit(delim)) {
            throw new RuntimeException(name + " must not be an alpha or digit");
        }
    }

    public void validate() {
        this.validateSeparator("dataSeparator", this.dataSeparator);
        this.validateSeparator("componentSeparator", this.componentSeparator);
        this.validateSeparator("repetitionSeparator", this.repetitionSeparator);
        this.validateSeparator("segmentTerminator", this.segmentTerminator);
        this.validateSeparator("releaseCharacter", this.releaseCharacter);
    }
}

