/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.flatfile.schema.test;

import com.mulesoft.flatfile.schema.SchemaJavaValues;
import com.mulesoft.flatfile.schema.edifact.EdifactFormConverter$;
import com.mulesoft.flatfile.schema.edifact.EdifactSchemaDefs;
import com.mulesoft.flatfile.schema.edifacttools.DecodeContrl$;
import com.mulesoft.flatfile.schema.edifacttools.DocumentTestEdifact;
import com.mulesoft.flatfile.schema.model.DelimitedCompositeComponent;
import com.mulesoft.flatfile.schema.model.EdiFormConverter;
import com.mulesoft.flatfile.schema.model.EdiSchema;
import com.mulesoft.flatfile.schema.model.SegmentComponent;
import com.mulesoft.flatfile.schema.tools.DocumentTest$;
import com.mulesoft.flatfile.schema.tools.YamlSupport;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TestEdifactDocument {
    private static final String CHARSET = "ISO8859-1";

    private static void printAcknowledgments(Map<String, Object> result) {
        List acks = (List)result.get(SchemaJavaValues.functionalAcksGenerated());
        if (acks != null) {
            String key = ((SegmentComponent)((DelimitedCompositeComponent)EdifactSchemaDefs.segUNBv4().components().head()).composite().components().apply(1)).key();
            for (Map ack : acks) {
                ((Map)ack.get(SchemaJavaValues.interchangeKey())).put(key, "4");
                System.out.println(DecodeContrl$.MODULE$.decode(ack));
            }
        }
    }

    private static void checkWrite(DocumentTestEdifact test, String text, Map<String, Object> result) {
        String input = DocumentTest$.MODULE$.stripLineBreaks(text);
        String outtext = test.printDoc(result);
        String output = DocumentTest$.MODULE$.stripLineBreaks(outtext);
        System.out.println("\nOutput comparison:");
        if (output.length() != input.length()) {
            System.out.println("Different lengths (" + output.length() + " vs " + input.length() + ")");
        }
        int length = Math.min(input.length(), output.length());
        int index = -1;
        while (++index < length && input.charAt(index) == output.charAt(index)) {
        }
        if (index < length) {
            System.out.println("Different text starting at " + index);
            int base = Math.max(index - 40, 0);
            int limit = Math.min(index + 40, length);
            System.out.println("output '" + output.substring(base, limit) + "'");
            System.out.println("input  '" + input.substring(base, limit) + "'");
        }
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            throw new IllegalArgumentException("Missing required argument(s): schema-path file-path [print/noprint]");
        }
        if (args.length > 3) {
            throw new IllegalArgumentException("Too many argument(s): schema-path file-path [print/noprint]");
        }
        boolean print = args.length > 2 && "print".equals(args[2]);
        EdiSchema schema = DocumentTest$.MODULE$.loadSchema(args[0], (EdiFormConverter)EdifactFormConverter$.MODULE$);
        DocumentTestEdifact test = new DocumentTestEdifact(schema);
        try {
            String input = DocumentTest$.MODULE$.readAsString(args[1]);
            ByteArrayInputStream is = new ByteArrayInputStream(input.getBytes(CHARSET));
            Map result = test.parse((InputStream)is);
            System.out.println("\nFunctional acknowledgement(s):");
            TestEdifactDocument.printAcknowledgments(result);
            test.prepareOutput(result);
            if (!result.containsKey(SchemaJavaValues.delimiterCharacters())) {
                result.put(SchemaJavaValues.delimiterCharacters(), "+:*'?");
            }
            HashMap<String, String> copy = new HashMap<String, String>(result);
            String delims = (String)copy.get(SchemaJavaValues.delimiterCharacters());
            delims = delims.substring(0, 3) + "\n" + delims.substring(4);
            copy.put(SchemaJavaValues.delimiterCharacters(), delims);
            System.out.println("Acknowledgment message(s):");
            System.out.println(test.printAck(copy));
            Map messages = (Map)result.get(EdifactSchemaDefs.messagesMap());
            if (messages != null && messages.size() > 0) {
                if (print) {
                    StringWriter writer = new StringWriter();
                    YamlSupport.writeMap((Map)result, (Writer)writer);
                    String output = writer.toString();
                    System.out.println("Message data:");
                    System.out.println(output);
                }
                TestEdifactDocument.checkWrite(test, input, result);
            } else {
                System.out.println("Message data not present");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

