/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.b2b.sync;

import com.mulesoft.b2b.sync.ObjectStoreOperation;
import com.mulesoft.b2b.sync.ObjectStoreSyncKeyManagement;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectStoreSimpleManagement
extends ObjectStoreSyncKeyManagement {
    private static final Logger logger = LoggerFactory.getLogger(ObjectStoreSimpleManagement.class);
    private final LockFactory lockFactory;
    private final Map<String, Lock> keyLocks;
    private static final long LOCK_WAIT_SECONDS = 15L;

    public ObjectStoreSimpleManagement(LockFactory lockFactory, ObjectStoreManager osManager, String idObjectStore, Integer daysToStore) {
        super(osManager, idObjectStore, daysToStore);
        this.lockFactory = lockFactory;
        this.keyLocks = new HashMap<String, Lock>();
    }

    private synchronized Lock getLockFor(String key) {
        if (this.keyLocks.containsKey(key)) {
            return this.keyLocks.get(key);
        }
        Lock lock = this.lockFactory.createLock(key);
        this.keyLocks.put(key, lock);
        return lock;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Object withSync(String key, ObjectStoreOperation operation) {
        Lock lockToUse = this.getLockFor(key);
        try {
            if (!lockToUse.tryLock(15L, TimeUnit.SECONDS)) {
                logger.error("Could not acquire lock to increment number " + key);
                throw new RuntimeException("Could not acquire lock to increment number " + key);
            }
            try {
                Object r = operation.apply();
                return r;
            }
            catch (ObjectStoreException e) {
                logger.error("Error trying to get key value", (Throwable)e);
                throw new RuntimeException(e);
            }
            finally {
                lockToUse.unlock();
            }
        }
        catch (InterruptedException ie) {
            String excMessage = "Failed acquiring lock to increment number " + key;
            logger.error(excMessage, (Throwable)ie);
            throw new RuntimeException(excMessage, ie);
        }
    }
}

