/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.b2b.sync;

import com.mulesoft.b2b.sync.IncrementStringOp;
import com.mulesoft.b2b.sync.ObjectStoreOperation;
import java.io.Serializable;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreException;

public class GetStringFromObjectStore
implements ObjectStoreOperation<String> {
    private final ObjectStore counterObjectStore;
    private final String key;
    private final String initial;
    private final IncrementStringOp incrementStringOp;

    public GetStringFromObjectStore(ObjectStore counterObjectStore, String key, String initial, IncrementStringOp incrementStringOp) {
        this.counterObjectStore = counterObjectStore;
        this.key = key;
        this.initial = initial;
        this.incrementStringOp = incrementStringOp;
    }

    @Override
    public String apply() throws ObjectStoreException {
        String count;
        if (this.counterObjectStore.contains(this.key)) {
            count = this.getStringValue(this.counterObjectStore.retrieve(this.key));
            if (count == null) {
                throw new RuntimeException("String value expected for key: " + this.key);
            }
            count = this.incrementStringOp.increment(count);
            this.counterObjectStore.remove(this.key);
        } else {
            count = this.initial;
        }
        this.counterObjectStore.store(this.key, (Serializable)((Object)count));
        return count;
    }

    private String getStringValue(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof TypedValue) {
            Object typedValue = ((TypedValue)value).getValue();
            if (typedValue instanceof String) {
                return (String)typedValue;
            }
            if (typedValue instanceof Integer) {
                return String.valueOf(typedValue);
            }
        }
        return null;
    }
}

