/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.b2b.sync;

import com.mulesoft.b2b.sync.ObjectStoreOperation;
import com.mulesoft.b2b.sync.ObjectStoreSyncKeyManagement;
import java.io.Serializable;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectStoreCloudhubManagement
extends ObjectStoreSyncKeyManagement {
    private static final int LOCK_RETRY_COUNT = 10;
    private static final int RELEASE_RETRY_COUNT = 12;
    private static final long BASE_RETRY_DELAY_MS = 100L;
    private static final long MAX_RETRY_DELAY_MS = 300L;
    private static final Logger logger = LoggerFactory.getLogger(ObjectStoreCloudhubManagement.class);

    public ObjectStoreCloudhubManagement(ObjectStoreManager osManager, String idObjectStore, Integer daysToStore) {
        super(osManager, idObjectStore, daysToStore);
    }

    @Override
    protected synchronized Object withSync(String key, ObjectStoreOperation operation) {
        this.getLockFor(key);
        try {
            Object r = operation.apply();
            return r;
        }
        catch (Exception e) {
            logger.error("Error trying to get key value", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            this.releaseLock(key);
        }
    }

    private void getLockFor(String key) {
        String lockKey = key + "-LOCK";
        this.osWithRetrys(10, 100L, 300L, "acquire ObjectStore lock " + lockKey, () -> {
            this.getCounterObjectStore().store(lockKey, (Serializable)Boolean.TRUE);
            return true;
        });
    }

    private void releaseLock(String key) {
        String lockKey = key + "-LOCK";
        this.osWithRetrys(12, 100L, 300L, "release ObjectStore lock " + lockKey, () -> {
            this.getCounterObjectStore().remove(lockKey);
            return true;
        });
    }

    private <R> R osWithRetrys(int retryCount, long baseDelay, long maxDelay, String task, ObjectStoreOperation<R> body) {
        long delay = baseDelay;
        ObjectStoreException ex = null;
        for (int retrys = retryCount; retrys > 0; --retrys) {
            try {
                return body.apply();
            }
            catch (ObjectStoreException e) {
                ex = e;
                logger.warn("Exception attempting to " + task, (Throwable)e);
                try {
                    Thread.currentThread();
                    Thread.sleep(delay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                delay = Math.min(delay * 2L, maxDelay);
                continue;
            }
        }
        logger.error("Failed trying to " + task, (Throwable)ex);
        throw new RuntimeException("Failed trying to " + task, ex);
    }
}

