/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.b2b.sync;

import com.mulesoft.b2b.sync.KeyManagement;
import com.mulesoft.b2b.sync.KeyManagementProvider;
import com.mulesoft.b2b.sync.ObjectStoreCloudhubManagement;
import com.mulesoft.b2b.sync.ObjectStoreSimpleManagement;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectStoreKeyManagementProvider
implements KeyManagementProvider {
    private final LockFactory lockFactory;
    private final ObjectStoreManager osManager;
    private final String idObjectStore;
    private final Integer daysToStore;
    private static final Logger logger = LoggerFactory.getLogger(ObjectStoreKeyManagementProvider.class);

    public ObjectStoreKeyManagementProvider(LockFactory lockFactory, ObjectStoreManager osManager, String idObjectStore, Integer daysToStore) {
        this.lockFactory = lockFactory;
        this.osManager = osManager;
        this.idObjectStore = idObjectStore;
        this.daysToStore = daysToStore;
    }

    @Override
    public KeyManagement createKeyManagement() {
        String workerIp = System.getProperty("worker.publicIP");
        if (workerIp != null && workerIp.length() > 0) {
            logger.info("Cloud hub object store lock");
            return new ObjectStoreCloudhubManagement(this.osManager, this.idObjectStore, this.daysToStore);
        }
        logger.info("LockFactory object store lock");
        return new ObjectStoreSimpleManagement(this.lockFactory, this.osManager, this.idObjectStore, this.daysToStore);
    }
}

