/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.b2b.sync;

import com.mulesoft.b2b.sync.GetIntegerFromObjectStore;
import com.mulesoft.b2b.sync.GetStringFromObjectStore;
import com.mulesoft.b2b.sync.IncrementStringOp;
import com.mulesoft.b2b.sync.KeyManagement;
import com.mulesoft.b2b.sync.ObjectStoreOperation;
import java.io.Serializable;
import org.mule.runtime.api.store.ObjectAlreadyExistsException;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.mule.runtime.api.store.ObjectStoreSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ObjectStoreSyncKeyManagement
implements KeyManagement {
    private static final Logger logger = LoggerFactory.getLogger(ObjectStoreSyncKeyManagement.class);
    private final ObjectStore counterObjectStore;

    protected ObjectStoreSyncKeyManagement(ObjectStoreManager osManager, String idObjectStore, Integer daysToStore) {
        long ttl = daysToStore.longValue() * 24L * 60L * 60L * 1000L;
        this.counterObjectStore = osManager.getOrCreateObjectStore(idObjectStore, ObjectStoreSettings.builder().persistent(true).maxEntries(Integer.valueOf(0)).entryTtl(Long.valueOf(ttl)).expirationInterval(Long.valueOf(ttl / 4L)).build());
    }

    @Override
    public synchronized boolean keyNotDuplicated(String keyGroup, String key) {
        try {
            String keyToUse = keyGroup + "-" + key;
            this.counterObjectStore.store(keyToUse, (Serializable)((Object)""));
            logger.info("Key used " + keyToUse);
            return true;
        }
        catch (ObjectAlreadyExistsException e) {
            logger.info("Key " + key + " already exists for " + keyGroup);
            return false;
        }
        catch (ObjectStoreException e) {
            String excMessage = "Error trying to validate duplicate for " + key + " for " + keyGroup;
            logger.error(excMessage, (Throwable)e);
            throw new RuntimeException(excMessage, e);
        }
    }

    protected abstract Object withSync(String var1, ObjectStoreOperation var2);

    @Override
    public Integer nextKeyValue(String key, Integer initial) {
        return (Integer)this.withSync(key, new GetIntegerFromObjectStore(this.counterObjectStore, key, initial));
    }

    @Override
    public String nextStringKeyValue(String key, String initial, IncrementStringOp operation) {
        return (String)this.withSync(key, new GetStringFromObjectStore(this.counterObjectStore, key, initial, operation));
    }

    protected ObjectStore getCounterObjectStore() {
        return this.counterObjectStore;
    }
}

