/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.b2b.sync;

import com.mulesoft.b2b.sync.ObjectStoreOperation;
import com.mulesoft.b2b.sync.ObjectStoreSyncKeyManagement;
import java.io.Serializable;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectStoreCloudhubManagement
extends ObjectStoreSyncKeyManagement {
    private static final long LOCK_WAIT_SECONDS = 15L;
    private static final long BASE_RETRY_DELAY_MS = 100L;
    private static final long MAX_RETRY_DELAY_MS = 300L;
    private static final Logger logger = LoggerFactory.getLogger(ObjectStoreCloudhubManagement.class);

    public ObjectStoreCloudhubManagement(ObjectStoreManager osManager, String idObjectStore, Integer daysToStore) {
        super(osManager, idObjectStore, daysToStore);
    }

    @Override
    protected synchronized Object withSync(String key, ObjectStoreOperation operation) {
        this.getLockFor(key);
        try {
            logger.debug("Lock obtained for " + key);
            Object r = operation.apply();
            return r;
        }
        catch (Exception e) {
            logger.error("Error trying to get key value", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            logger.debug("Task finished. Releasing lock for " + key);
            this.releaseLock(key);
            logger.debug("Lock released for " + key);
        }
    }

    private void getLockFor(String key) {
        String lockKey = key + "-LOCK";
        this.osWithRetrys(100L, 300L, "acquire ObjectStore lock " + lockKey, () -> {
            this.getCounterObjectStore().store(lockKey, (Serializable)Boolean.TRUE);
            return true;
        });
    }

    private void releaseLock(String key) {
        String lockKey = key + "-LOCK";
        this.osWithRetrys(100L, 300L, "release ObjectStore lock " + lockKey, () -> {
            this.getCounterObjectStore().remove(lockKey);
            return true;
        });
    }

    private <R> R osWithRetrys(long baseDelay, long maxDelay, String task, ObjectStoreOperation<R> body) {
        int attempt = 1;
        long maxTime = System.currentTimeMillis() + 15000L;
        long delay = baseDelay;
        Object ex = null;
        while (System.currentTimeMillis() < maxTime) {
            try {
                R ret = body.apply();
                logger.debug("SUCCESS operation " + task);
                return ret;
            }
            catch (ObjectStoreException e) {
                logger.warn("Can't get lock to " + task + " attempp " + attempt + "[" + e.getMessage() + "]");
                try {
                    Thread.currentThread();
                    Thread.sleep(delay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++attempt;
                delay = Math.min(delay * 2L, maxDelay);
            }
        }
        logger.error("Failed trying to " + task + " after " + attempt + " attemps. Waiting " + 15L + " seconds");
        throw new RuntimeException("Failed trying to " + task);
    }

    @Override
    public String getInfo() {
        return "CloudObjectStore sync for " + super.getInfo();
    }
}

